/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.ticker;

import net.openhft.chronicle.ticker.MicroTicker;
import net.openhft.chronicle.ticker.MilliTicker;
import net.openhft.chronicle.ticker.NanoTicker;
import net.openhft.chronicle.ticker.NativeTime;
import net.openhft.chronicle.ticker.RdtscTicker;
import net.openhft.chronicle.ticker.SetTicker;

public interface Ticker {
    public long count();

    public long countPerSecond();

    public long countFromEpoch();

    public static long nanoClock() {
        return NativeTime.clocknanos();
    }

    public static SetTicker forTesting() {
        return new SetTicker();
    }

    public static Ticker milli() {
        return MilliTicker.INSTANCE;
    }

    public static Ticker micro() {
        return MicroTicker.INSTANCE;
    }

    public static Ticker nano() {
        return NanoTicker.INSTANCE;
    }

    public static Ticker highResolution() {
        return NativeTime.LOADED ? RdtscTicker.INSTANCE : NanoTicker.INSTANCE;
    }
}

