/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import net.openhft.chronicle.values.ValueModel;

public final class Values {
    private Values() {
    }

    public static boolean isValueInterfaceOrImplClass(Class<?> valueTypeOrImplClass) {
        return ValueModel.isValueInterfaceOrImplClass(valueTypeOrImplClass);
    }

    public static <T> T newHeapInstance(Class<T> valueType) {
        try {
            return Values.heapClassFor(valueType).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> T newNativeReference(Class<T> valueType) {
        try {
            return Values.nativeClassFor(valueType).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> Class<T> heapClassFor(Class<T> valueType) {
        return ValueModel.acquire(valueType).heapClass();
    }

    public static <T> Class<T> nativeClassFor(Class<T> valueType) {
        return ValueModel.acquire(valueType).nativeClass();
    }
}

