/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;

enum Nullability {
    NULLABLE,
    NOT_NULL;


    static Nullability explicitNullability(Parameter p) {
        boolean hasNotNullAnnotation = Nullability.hasNotNullAnnotation(p);
        boolean hasNullableAnnotation = Nullability.hasNullableAnnotation(p);
        if (hasNotNullAnnotation && hasNullableAnnotation) {
            throw new IllegalStateException("Param " + p + " has both @Nullable and @NotNull annotations");
        }
        if (hasNotNullAnnotation) {
            return NOT_NULL;
        }
        if (hasNullableAnnotation) {
            return NULLABLE;
        }
        return null;
    }

    static boolean hasNullableAnnotation(Parameter p) {
        for (Annotation a : p.getAnnotations()) {
            if (!a.annotationType().getSimpleName().equalsIgnoreCase("Nullable")) continue;
            return true;
        }
        return false;
    }

    static boolean hasNotNullAnnotation(Parameter p) {
        for (Annotation a : p.getAnnotations()) {
            String annotationName = a.annotationType().getSimpleName();
            if (!annotationName.equalsIgnoreCase("NotNull") && !annotationName.equalsIgnoreCase("Nonnull")) continue;
            return true;
        }
        return false;
    }
}

