/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.CountingDocumentContext;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public class BinaryMethodWriterInvocationHandler
extends AbstractMethodWriterInvocationHandler {
    @NotNull
    private final Supplier<MarshallableOut> marshallableOutSupplier;
    private final boolean metaData;
    @NotNull
    private final CountingDocumentContext context = new CountingDocumentContext();

    BinaryMethodWriterInvocationHandler(boolean metaData, @NotNull MarshallableOut marshallableOut) {
        this(metaData, () -> marshallableOut);
    }

    public BinaryMethodWriterInvocationHandler(boolean metaData, Supplier<MarshallableOut> marshallableOutSupplier) {
        this.marshallableOutSupplier = marshallableOutSupplier;
        this.metaData = metaData;
        this.recordHistory = marshallableOutSupplier.get().recordHistory();
    }

    @Override
    protected Object doInvoke(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("writingDocument") && method.getParameterCount() == 0) {
            MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
            this.context.count = 0;
            return this.context.dc(marshallableOut.writingDocument(this.metaData));
        }
        return super.doInvoke(proxy, method, args);
    }

    public boolean metaData() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleInvoke(Method method, Object[] args) {
        DocumentContext dc = this.context.dc();
        boolean chained = method.getReturnType().isInterface();
        if (dc == null) {
            MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
            dc = marshallableOut.writingDocument(this.metaData);
            if (chained) {
                this.context.dc(dc);
            }
            this.context.local = true;
        }
        try {
            Wire wire = dc.wire();
            this.handleInvoke(method, args, wire);
            wire.padToCacheAlign();
        }
        catch (Throwable t) {
            dc.rollbackOnClose();
            Jvm.rethrow((Throwable)t);
        }
        finally {
            if (!chained) {
                if (this.context.local) {
                    dc.close();
                    this.context.dc(null);
                    this.context.local = false;
                } else {
                    ++this.context.count;
                }
            }
        }
    }
}

