/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.util.Annotations;
import net.openhft.chronicle.core.util.InvocationTargetRuntimeException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.FieldNumberParselet;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodFilterOnFirstArg;
import net.openhft.chronicle.wire.MethodWireKey;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ReflectionUtil;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class VanillaMethodReader
implements MethodReader {
    public static final boolean DEBUG_ENABLED = Jvm.isDebugEnabled(VanillaMethodReader.class) && Jvm.getBoolean((String)"wire.mr.debug");
    static final Object[] NO_ARGS = new Object[0];
    static final Object IGNORED = new Object();
    private final MarshallableIn in;
    @NotNull
    private final WireParser metaWireParser;
    private final WireParser dataWireParser;
    private final MethodReaderInterceptorReturns methodReaderInterceptorReturns;
    private MessageHistory messageHistory;
    private boolean closeIn = false;
    private boolean closed;

    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, MethodReaderInterceptorReturns methodReaderInterceptorReturns, Object[] metaDataHandler, Object ... objects) {
        this(in, ignoreDefault, defaultParselet, VanillaWireParser.SKIP_READABLE_BYTES, methodReaderInterceptorReturns, metaDataHandler, objects);
    }

    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, FieldNumberParselet fieldNumberParselet, MethodReaderInterceptorReturns methodReaderInterceptorReturns, Object ... objects) {
        this(in, ignoreDefault, defaultParselet, fieldNumberParselet, methodReaderInterceptorReturns, (Object[])null, objects);
    }

    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, FieldNumberParselet fieldNumberParselet, MethodReaderInterceptorReturns methodReaderInterceptorReturns, Object[] metaDataHandler, Object ... objects) {
        this.in = in;
        this.methodReaderInterceptorReturns = methodReaderInterceptorReturns;
        if (objects[0] instanceof WireParselet) {
            defaultParselet = (WireParselet)objects[0];
        }
        this.metaWireParser = WireParser.wireParser((s, in0) -> in0.skipValue());
        this.dataWireParser = WireParser.wireParser(defaultParselet, fieldNumberParselet);
        this.addParsersForComponents(this.metaWireParser, ignoreDefault, this.addObjectsToMetaDataHandlers(metaDataHandler, objects));
        this.addParsersForComponents(this.dataWireParser, ignoreDefault, objects);
        if (this.dataWireParser.lookup("history") == null) {
            this.dataWireParser.register(new MethodWireKey("history", -1), (s, v) -> v.marshallable(this.messageHistory));
        }
    }

    private static LongConversion longConversionForFirstParam(Method m) {
        Annotation[][] annotations = m.getParameterAnnotations();
        if (annotations == null || annotations.length < 1 || annotations[0].length < 1) {
            return null;
        }
        for (Annotation annotation : annotations[0]) {
            if (!(annotation instanceof LongConversion)) continue;
            return (LongConversion)annotation;
        }
        return null;
    }

    private static void invokeMethodWithOneLong(Object o, Object[] context, @NotNull Method m, String name, MethodHandle mh, Object[] argArr, CharSequence s, ValueIn v, MethodReaderInterceptorReturns methodReaderInterceptor) {
        block16: {
            try {
                if (Jvm.isDebug()) {
                    VanillaMethodReader.logMessage(s, v);
                }
                if (context[0] == null) {
                    VanillaMethodReader.updateContext(context, o);
                }
                long arg = 0L;
                if (v.isBinary()) {
                    arg = v.int64();
                } else {
                    LongConversion lc = VanillaMethodReader.longConversionForFirstParam(m);
                    if (lc == null) {
                        arg = v.int64();
                    } else {
                        String text = v.text();
                        if (text != null && !text.isEmpty()) {
                            LongConverter longConverter = (LongConverter)ObjectUtils.newInstance(lc.value());
                            arg = longConverter.parse(text);
                        }
                    }
                }
                if (methodReaderInterceptor != null) {
                    argArr[0] = arg;
                    Object intercept = methodReaderInterceptor.intercept(m, context[0], argArr, VanillaMethodReader::actualInvoke);
                    VanillaMethodReader.updateContext(context, intercept);
                    break block16;
                }
                if (mh == null) {
                    argArr[0] = arg;
                    VanillaMethodReader.updateContext(context, m.invoke(context[0], argArr));
                    break block16;
                }
                try {
                    if (m.getReturnType() == Void.TYPE) {
                        mh.invokeExact(arg);
                        VanillaMethodReader.updateContext(context, null);
                    } else {
                        VanillaMethodReader.updateContext(context, mh.invokeExact(arg));
                    }
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t);
                }
            }
            catch (InvocationTargetException e) {
                throw new InvocationTargetRuntimeException((Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Failure to dispatch message: " + m.getName() + " " + Arrays.asList(argArr);
                Jvm.warn().on(o.getClass(), msg, e);
            }
        }
    }

    private static void updateContext(Object[] context, Object intercept) {
        context[0] = intercept;
    }

    private static Object actualInvoke(Method method, Object o, Object[] objects) throws InvocationTargetException {
        try {
            return method.invoke(o, objects);
        }
        catch (IllegalAccessException iae) {
            throw Jvm.rethrow((Throwable)iae);
        }
    }

    public static void logMessage(@NotNull CharSequence s, @NotNull ValueIn v) {
        if (!DEBUG_ENABLED) {
            return;
        }
        Jvm.debug().on(VanillaMethodReader.class, VanillaMethodReader.logMessage0(s, v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static String logMessage0(@NotNull CharSequence s, @NotNull ValueIn v) {
        try {
            String rest;
            if (v.wireIn().isBinary()) {
                Bytes<?> bytes0 = v.wireIn().bytes();
                OnHeapBytes bytes = Bytes.allocateElasticOnHeap((int)((int)(bytes0.readRemaining() * 3L / 2L + 64L)));
                long pos = bytes0.readPosition();
                try {
                    v.wireIn().copyTo((WireOut)WireType.TEXT.apply(bytes));
                    rest = bytes.toString();
                }
                catch (Exception t) {
                    rest = bytes0.toHexString(pos, bytes0.readLimit() - pos);
                }
                finally {
                    bytes0.readPosition(pos);
                    bytes.releaseLast();
                }
            } else {
                rest = v.toString();
            }
            if (rest.endsWith("\n")) {
                rest = rest.substring(0, rest.length() - 1);
            }
            return "read " + s + " - " + rest;
        }
        catch (Exception e) {
            return "read " + s + " - " + e;
        }
    }

    private Object[] addObjectsToMetaDataHandlers(Object[] metaDataHandler, @NotNull @NotNull Object @NotNull [] objects) {
        if (metaDataHandler == null) {
            metaDataHandler = objects;
        } else {
            LinkedHashSet metaDataHandlerSet = new LinkedHashSet();
            Collections.addAll(metaDataHandlerSet, metaDataHandler);
            Collections.addAll(metaDataHandlerSet, objects);
            metaDataHandler = metaDataHandlerSet.toArray();
        }
        return metaDataHandler;
    }

    private void addParsersForComponents(WireParser wireParser, boolean ignoreDefault, @NotNull @NotNull Object @NotNull [] objects) {
        @NotNull HashSet<String> methodsSignaturesHandled = new HashSet<String>();
        @NotNull HashSet<String> methodsNamesHandled = new HashSet<String>();
        MethodFilterOnFirstArg methodFilterOnFirstArg = null;
        for (Object o : objects) {
            if (o instanceof MethodFilterOnFirstArg) {
                if (methodFilterOnFirstArg != null) {
                    Jvm.warn().on(this.getClass(), "Multiple filters on first arg not supported, only the first one is applied.");
                } else {
                    methodFilterOnFirstArg = (MethodFilterOnFirstArg)o;
                }
            }
            Class<?> oClass = o.getClass();
            Object[] context = new Object[]{null};
            Supplier<Object> original = () -> o;
            Supplier<Object> inarray = () -> context[0];
            LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
            for (Class<?> anInterface : ReflectionUtil.interfaces(oClass)) {
                this.addParsletsFor(wireParser, interfaces, anInterface, ignoreDefault, methodsNamesHandled, methodsSignaturesHandled, methodFilterOnFirstArg, o, context, original, inarray);
            }
        }
    }

    private void addParsletsFor(WireParser wireParser, Set<Class> interfaces, Class<?> oClass, boolean ignoreDefault, Set<String> methodNamesHandled, Set<String> methodsSignaturesHandled, MethodFilterOnFirstArg methodFilterOnFirstArg, Object o, Object[] context, Supplier contextSupplier, Supplier nextContext) {
        if (!oClass.isInterface() || Jvm.dontChain(oClass)) {
            return;
        }
        if (!interfaces.add(oClass)) {
            return;
        }
        block6: for (Method m : oClass.getMethods()) {
            Class<?> declaringClass = m.getDeclaringClass();
            if (declaringClass == Object.class || Modifier.isStatic(m.getModifiers()) || ignoreDefault && declaringClass.isInterface() || "ignoreMethodBasedOnFirstArg".equals(m.getName()) || !methodsSignaturesHandled.add(this.signature(m))) continue;
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!methodNamesHandled.add(m.getName())) {
                    String previous = methodsSignaturesHandled.stream().filter(signature -> signature.contains(" " + m.getName() + " ")).findFirst().orElseThrow(IllegalStateException::new);
                    String msg = m + " previous: " + previous;
                    throw new IllegalStateException("MethodReader does not support overloaded methods. Method: " + msg);
                }
                Class[] parameterTypes = m.getParameterTypes();
                switch (parameterTypes.length) {
                    case 0: {
                        this.addParseletForMethod(wireParser, o, context, contextSupplier, m);
                        continue block6;
                    }
                    case 1: {
                        this.addParseletForMethod(wireParser, o, context, contextSupplier, m, parameterTypes[0]);
                        continue block6;
                    }
                    default: {
                        if (methodFilterOnFirstArg == null) {
                            this.addParseletForMethod(wireParser, o, context, contextSupplier, m, parameterTypes);
                            continue block6;
                        }
                        this.addParseletForMethod(wireParser, o, context, contextSupplier, m, parameterTypes, methodFilterOnFirstArg);
                    }
                }
            }
        }
        for (Method m : oClass.getMethods()) {
            Class<?> returnType = m.getReturnType();
            this.addParsletsFor(wireParser, interfaces, returnType, ignoreDefault, methodNamesHandled, methodsSignaturesHandled, methodFilterOnFirstArg, o, context, nextContext, nextContext);
        }
    }

    private String signature(Method m) {
        return m.getReturnType() + " " + m.getName() + " " + Arrays.toString(m.getParameterTypes());
    }

    @NotNull
    public VanillaMethodReader closeIn(boolean closeIn) {
        this.throwExceptionIfClosed();
        this.closeIn = closeIn;
        return this;
    }

    public void throwExceptionIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
    }

    public void addParseletForMethod(WireParser wireParser, Object o2, Object[] context, Supplier contextSupplier, @NotNull Method m, Class<?> parameterType) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)m);
        String name = m.getName();
        Class parameterType2 = ObjectUtils.implementationToUse(parameterType);
        if (parameterType == Long.TYPE && o2 != null) {
            try {
                MethodHandle mh = m.getDeclaringClass().isInstance(o2) ? MethodHandles.lookup().unreflect(m).bindTo(o2) : null;
                Object[] argArr = new Object[]{null};
                MethodWireKey key = this.createWireKey(m, name);
                wireParser.registerOnce(key, (s, v) -> VanillaMethodReader.invokeMethodWithOneLong(o2, context, m, name, mh, argArr, s, v, this.methodReaderInterceptorReturns));
            }
            catch (IllegalAccessException e) {
                Jvm.warn().on(o2.getClass(), "Unable to unreflect " + m, (Throwable)e);
            }
        } else if (parameterType.isPrimitive() || parameterType2.isInterface() || !ReadMarshallable.class.isAssignableFrom(parameterType2)) {
            Object[] argArr = new Object[]{null};
            MethodWireKey key = this.createWireKey(m, name);
            wireParser.registerOnce(key, (s, v) -> {
                if (Jvm.isDebug()) {
                    VanillaMethodReader.logMessage(s, v);
                }
                argArr[0] = v.object(this.checkRecycle(argArr[0]), parameterType2);
                if (context[0] == null) {
                    VanillaMethodReader.updateContext(context, o2);
                }
                Object invoke = this.invoke(context[0], m, argArr);
                VanillaMethodReader.updateContext(context, invoke);
            });
        } else {
            ReadMarshallable arg = (ReadMarshallable)ObjectUtils.newInstance((Class)parameterType2);
            ReadMarshallable[] argArr = new ReadMarshallable[]{arg};
            MethodWireKey key = this.createWireKey(m, name);
            wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$7(argArr, parameterType2, context, o2, (Supplier)contextSupplier, m, arg_0, arg_1));
        }
    }

    public void addParseletForMethod(WireParser wireParser, Object o2, Object[] context, Supplier contextSupplier, @NotNull Method m) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)m);
        String name = m.getName();
        MethodWireKey key = this.createWireKey(m, name);
        wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$8((Supplier)contextSupplier, m, context, o2, arg_0, arg_1));
    }

    @NotNull
    protected MethodWireKey createWireKey(@NotNull Method m, String name) {
        MethodId annotation = (MethodId)Annotations.getAnnotation((Method)m, MethodId.class);
        return new MethodWireKey(name, annotation == null ? name.hashCode() : Maths.toInt32((long)annotation.value()));
    }

    public void addParseletForMethod(WireParser wireParser, Object o2, Object[] context, Supplier contextSupplier, @NotNull Method m, @NotNull Class[] parameterTypes) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)m);
        @NotNull Object[] args = new Object[parameterTypes.length];
        @NotNull BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            for (Class clazz : parameterTypes) {
                a[i] = v.object(this.checkRecycle(a[i]), clazz);
                ++i;
            }
        };
        String name = m.getName();
        MethodWireKey key = this.createWireKey(m, name);
        wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$10(args, sequenceReader, (Supplier)contextSupplier, m, context, o2, arg_0, arg_1));
    }

    private <T> T checkRecycle(T o) {
        if (o instanceof Collection) {
            ((Collection)o).clear();
            return o;
        }
        return (T)(o instanceof Marshallable ? o : null);
    }

    public void addParseletForMethod(WireParser wireParser, Object o2, Object[] context, Supplier contextSupplier, @NotNull Method m, @NotNull Class[] parameterTypes, MethodFilterOnFirstArg methodFilterOnFirstArg) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)m);
        @NotNull Object[] args = new Object[parameterTypes.length];
        @NotNull BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            boolean ignored = false;
            for (Class clazz : parameterTypes) {
                if (ignored) {
                    v.skipValue();
                } else {
                    a[i] = v.object(this.checkRecycle(a[i]), clazz);
                }
                if (i == 0 && methodFilterOnFirstArg.ignoreMethodBasedOnFirstArg(m.getName(), a[0])) {
                    a[0] = IGNORED;
                    ignored = true;
                }
                ++i;
            }
        };
        String name = m.getName();
        MethodWireKey key = this.createWireKey(m, name);
        wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$12(args, sequenceReader, (Supplier)contextSupplier, m, context, o2, arg_0, arg_1));
    }

    protected Object invoke(Object o, @NotNull Method m, Object[] args) throws InvocationTargetRuntimeException {
        try {
            if (this.methodReaderInterceptorReturns != null) {
                return this.methodReaderInterceptorReturns.intercept(m, o, args, VanillaMethodReader::actualInvoke);
            }
            return m.invoke(o, args);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e.getCause());
        }
        catch (IllegalAccessException e) {
            Throwable cause = e.getCause();
            String msg = "Failure to dispatch message: " + m.getName() + " " + Arrays.asList(args);
            if (cause instanceof IllegalArgumentException) {
                Jvm.warn().on(o.getClass(), msg + " " + cause);
            } else {
                Jvm.warn().on(o.getClass(), msg, cause);
            }
            return null;
        }
    }

    public boolean readOne() throws InvocationTargetRuntimeException {
        this.throwExceptionIfClosed();
        return this.readOne0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readOne0() {
        try (DocumentContext context = this.in.readingDocument();){
            if (!context.isPresent()) {
                boolean bl = false;
                return bl;
            }
            if (context.isMetaData()) {
                this.metaWireParser.accept(context.wire());
                boolean bl = true;
                return bl;
            }
            assert (context.isData());
            this.messageHistory().reset(context.sourceId(), context.index());
            this.dataWireParser.accept(context.wire());
        }
        finally {
            this.messageHistory().reset();
        }
        return true;
    }

    private MessageHistory messageHistory() {
        if (this.messageHistory == null) {
            this.messageHistory = MessageHistory.get();
        }
        return this.messageHistory;
    }

    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MethodReaderInterceptorReturns methodReaderInterceptorReturns() {
        this.throwExceptionIfClosed();
        return this.methodReaderInterceptorReturns;
    }

    private /* synthetic */ void lambda$addParseletForMethod$12(Object[] args, BiConsumer sequenceReader, Supplier contextSupplier, Method m, Object[] context, Object o2, CharSequence s, ValueIn v) throws InvalidMarshallableException {
        if (Jvm.isDebug()) {
            VanillaMethodReader.logMessage(s, v);
        }
        v.sequence(args, sequenceReader);
        if (args[0] == IGNORED) {
            args[0] = null;
            return;
        }
        Object invoke = this.invoke(contextSupplier.get(), m, args);
        if (invoke != null) {
            VanillaMethodReader.updateContext(context, invoke);
        } else if (o2 != null) {
            VanillaMethodReader.updateContext(context, o2);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$10(Object[] args, BiConsumer sequenceReader, Supplier contextSupplier, Method m, Object[] context, Object o2, CharSequence s, ValueIn v) throws InvalidMarshallableException {
        if (Jvm.isDebug()) {
            VanillaMethodReader.logMessage(s, v);
        }
        v.sequence(args, sequenceReader);
        Object invoke = this.invoke(contextSupplier.get(), m, args);
        if (invoke != null) {
            VanillaMethodReader.updateContext(context, invoke);
        } else if (o2 != null) {
            VanillaMethodReader.updateContext(context, o2);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$8(Supplier contextSupplier, Method m, Object[] context, Object o2, CharSequence s, ValueIn v) throws InvalidMarshallableException {
        if (Jvm.isDebug()) {
            VanillaMethodReader.logMessage(s, v);
        }
        v.skipValue();
        Object invoke = this.invoke(contextSupplier.get(), m, NO_ARGS);
        if (invoke != null) {
            VanillaMethodReader.updateContext(context, invoke);
        } else if (o2 != null) {
            VanillaMethodReader.updateContext(context, o2);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$7(ReadMarshallable[] argArr, Class parameterType2, Object[] context, Object o2, Supplier contextSupplier, Method m, CharSequence s, ValueIn v) throws InvalidMarshallableException {
        if (Jvm.isDebug()) {
            VanillaMethodReader.logMessage(s, v);
        }
        argArr[0] = v.object(this.checkRecycle(argArr[0]), parameterType2);
        if (context[0] == null) {
            VanillaMethodReader.updateContext(context, o2);
        }
        Object invoke = this.invoke(contextSupplier.get(), m, argArr);
        VanillaMethodReader.updateContext(context, invoke);
    }
}

