/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.LongConverter;

public abstract class AbstractTimestampLongConverter
implements LongConverter {
    public static final ZoneId UTC = ZoneId.of("UTC");
    public static final String TIMESTAMP_LONG_CONVERTERS_ZONE_ID_SYSTEM_PROPERTY = "timestampLongConverters.zoneId";
    public static final String INCLUDE_ZONE_SUFFIX_WHEN_ZONE_IS_UTC_SYSTEM_PROPERTY = "timestampLongConverters.includeZoneSuffixWhenZoneIsUTC";
    private final ZoneId zoneId;
    private final DateTimeFormatter formatterForParsing;
    private final DateTimeFormatter formatterForFormatting;
    private final boolean writingUtcDatesWithNoSuffix;
    private final long amountPerSecond;
    private final long nanosPerAmount;

    protected AbstractTimestampLongConverter(TimeUnit timeUnit) {
        this(System.getProperty(TIMESTAMP_LONG_CONVERTERS_ZONE_ID_SYSTEM_PROPERTY, UTC.toString()), timeUnit);
    }

    protected AbstractTimestampLongConverter(String zoneId, TimeUnit timeUnit) {
        this(zoneId, timeUnit, Jvm.getBoolean((String)INCLUDE_ZONE_SUFFIX_WHEN_ZONE_IS_UTC_SYSTEM_PROPERTY));
    }

    @Deprecated
    protected AbstractTimestampLongConverter(String zoneId, TimeUnit timeUnit, boolean includeZoneSuffixForUTC) {
        this.zoneId = ZoneId.of(zoneId);
        this.writingUtcDatesWithNoSuffix = this.zoneId.equals(UTC) && !includeZoneSuffixForUTC;
        this.amountPerSecond = timeUnit.convert(1L, TimeUnit.SECONDS);
        this.nanosPerAmount = TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        this.formatterForParsing = this.createFormatter();
        this.formatterForFormatting = this.writingUtcDatesWithNoSuffix ? this.createFormatterWithNoZoneSuffix() : this.formatterForParsing;
    }

    @Override
    public long parse(CharSequence text) {
        if (text == null || text.length() == 0) {
            return 0L;
        }
        try {
            TemporalAccessor parse;
            if (text.length() > 4 && text.charAt(4) == '/') {
                text = text.toString().replace('/', '-');
            }
            if ((parse = this.formatterForParsing.parse(text)).query(TemporalQueries.zoneId()) != null) {
                return this.parseFormattedDate(ZonedDateTime.from(parse).withZoneSameInstant(UTC));
            }
            return this.parseFormattedDate(LocalDateTime.from(parse).atZone(this.zoneId).withZoneSameInstant(UTC));
        }
        catch (DateTimeParseException dtpe) {
            try {
                return this.parseTimestamp(Long.parseLong(text.toString()), text);
            }
            catch (NumberFormatException e) {
                throw dtpe;
            }
        }
    }

    protected abstract long parseFormattedDate(ZonedDateTime var1);

    protected abstract long parseTimestamp(long var1, CharSequence var3);

    private DateTimeFormatter createFormatter() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss");
        this.appendFraction(builder);
        builder.optionalStart().appendOffsetId().optionalEnd();
        return builder.toFormatter();
    }

    private DateTimeFormatter createFormatterWithNoZoneSuffix() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss");
        this.appendFraction(builder);
        return builder.toFormatter();
    }

    protected abstract void appendFraction(DateTimeFormatterBuilder var1);

    public void append(Appendable text, long value) {
        if (value <= 0L) {
            AppendableUtil.append((Appendable)text, (long)value);
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(value / this.amountPerSecond, (int)(value % this.amountPerSecond * this.nanosPerAmount), ZoneOffset.UTC);
        if (this.writingUtcDatesWithNoSuffix) {
            this.formatterForFormatting.formatTo(ldt, text);
        } else {
            this.formatterForFormatting.formatTo(ZonedDateTime.of(ldt, UTC).withZoneSameInstant(this.zoneId), text);
        }
    }

    @Override
    public void append(StringBuilder text, long value) {
        this.append((Appendable)text, value);
    }

    @Override
    public void append(Bytes<?> bytes, long value) {
        this.append((Appendable)bytes, value);
    }
}

