/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.MethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.UpdateInterceptor;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.Builder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.GenerateMethodWriter;
import net.openhft.chronicle.wire.GenerateMethodWriter2;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MethodWriterInvocationHandlerSupplier;
import net.openhft.chronicle.wire.MethodWriterValidationException;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.internal.GenericReflection;
import net.openhft.chronicle.wire.internal.MethodWriterClassNameGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaMethodWriterBuilder<T>
implements Builder<T>,
MethodWriterBuilder<T> {
    public static final String DISABLE_WRITER_PROXY_CODEGEN = "disableProxyCodegen";
    private static final Class<?> COMPILE_FAILED = ClassNotFoundException.class;
    private static final Map<String, Class> classCache = new ConcurrentHashMap<String, Class>();
    private static final List<Class> invalidSuperInterfaces = Arrays.asList(ReadBytesMarshallable.class, WriteBytesMarshallable.class, ReadMarshallable.class, WriteMarshallable.class, Collection.class, Map.class, Iterator.class, Iterable.class, Comparable.class, Serializable.class, CharSequence.class, Comparable.class, Comparator.class);
    private final boolean disableProxyGen = Jvm.getBoolean((String)"disableProxyCodegen", (boolean)false);
    private final Set<Class<?>> interfaces = Collections.synchronizedSet(new LinkedHashSet());
    private final MethodWriterClassNameGenerator methodWriterClassNameGenerator;
    private final String packageName;
    private ClassLoader classLoader;
    @NotNull
    private final MethodWriterInvocationHandlerSupplier handlerSupplier;
    private Supplier<MarshallableOut> outSupplier;
    private Closeable closeable;
    private String genericEvent;
    private boolean metaData;
    private WireType wireType;
    private Class<?> proxyClass;
    private UpdateInterceptor updateInterceptor;
    private boolean verboseTypes;

    public VanillaMethodWriterBuilder(@NotNull Class<T> tClass, WireType wireType, @NotNull Supplier<MethodWriterInvocationHandler> handlerSupplier) {
        this.packageName = Jvm.getPackageName(tClass);
        this.wireType = wireType;
        this.addInterface(tClass);
        ClassLoader clsLdr = tClass.getClassLoader();
        this.classLoader = clsLdr != null ? clsLdr : this.getClass().getClassLoader();
        this.methodWriterClassNameGenerator = new MethodWriterClassNameGenerator();
        this.handlerSupplier = new MethodWriterInvocationHandlerSupplier(handlerSupplier);
    }

    @NotNull
    public MethodWriterBuilder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> updateInterceptor(UpdateInterceptor updateInterceptor) {
        this.updateInterceptor = updateInterceptor;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> verboseTypes(boolean verboseTypes) {
        this.verboseTypes = verboseTypes;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> addInterface(Class<?> additionalClass) {
        if (this.interfaces.contains(additionalClass)) {
            return this;
        }
        if (additionalClass == DocumentContext.class) {
            return this;
        }
        for (Class invalidSuperInterface : invalidSuperInterfaces) {
            if (!invalidSuperInterface.isAssignableFrom(additionalClass)) continue;
            throw new IllegalArgumentException("The event interface shouldn't implement " + invalidSuperInterface.getName());
        }
        this.interfaces.add(additionalClass);
        for (Method method : additionalClass.getMethods()) {
            Class returnClass;
            Type returnType = GenericReflection.getReturnType(method, additionalClass);
            if (!(returnType instanceof Class) || !(returnClass = (Class)returnType).isInterface() || Jvm.dontChain((Class)returnClass)) continue;
            this.addInterface(returnClass);
        }
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> disableThreadSafe(boolean theadSafe) {
        this.handlerSupplier.disableThreadSafe(theadSafe);
        return this;
    }

    @NotNull
    public T build() {
        return this.get();
    }

    @NotNull
    public MethodWriterBuilder<T> onClose(Closeable closeable) {
        this.closeable = closeable;
        this.handlerSupplier.onClose(closeable);
        return this;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public VanillaMethodWriterBuilder<T> wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    @NotNull
    private String getClassName() {
        return this.methodWriterClassNameGenerator.getClassName(this.interfaces, this.genericEvent, this.metaData, this.updateInterceptor != null, this.wireType(), this.verboseTypes);
    }

    @NotNull
    public T get() {
        block6: {
            if (this.proxyClass != null) {
                try {
                    Constructor<?> constructor = this.proxyClass.getConstructor(MethodWriterInvocationHandlerSupplier.class);
                    return (T)constructor.newInstance(this.handlerSupplier);
                }
                catch (Throwable e) {
                    if (!Jvm.isDebugEnabled(this.getClass())) break block6;
                    Jvm.debug().on(this.getClass(), e);
                }
            }
        }
        if (!this.disableProxyGen) {
            T t = this.createInstance();
            if (t != null) {
                return t;
            }
        } else {
            Jvm.warn().on(this.getClass(), "Falling back to proxy method writer. Support for proxy method writers will be dropped in x.25.");
        }
        @NotNull Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
        return (T)Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)new CallSupplierInvocationHandler(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T createInstance() {
        String fullClassName = this.packageName + "." + this.getClassName();
        try {
            try {
                return (T)this.newInstance(Class.forName(fullClassName));
            }
            catch (ClassNotFoundException e) {
                Class clazz;
                Map<String, Class> map = classCache;
                synchronized (map) {
                    clazz = classCache.computeIfAbsent(fullClassName, this::newClass);
                }
                if (clazz != null && clazz != COMPILE_FAILED) {
                    return (T)this.newInstance(clazz);
                }
            }
        }
        catch (MethodWriterValidationException e) {
            throw e;
        }
        catch (Throwable e) {
            classCache.put(fullClassName, COMPILE_FAILED);
            Jvm.warn().on(this.getClass(), "Failed to compile generated method writer - falling back to proxy method writer. Please report this failure as support for proxy method writers will be dropped in x.25.", e);
        }
        return null;
    }

    private Class<?> newClass(String fullClassName) {
        if (this.wireType.isText() || !Jvm.getBoolean((String)"wire.generator.v2")) {
            return GenerateMethodWriter.newClass(fullClassName, this.interfaces, this.classLoader, this.wireType, this.genericEvent, this.metaData, true, this.updateInterceptor != null, this.verboseTypes);
        }
        GenerateMethodWriter2 gmw = new GenerateMethodWriter2();
        ((GenerateMethodWriter2.GMWMetaData)((GenerateMethodWriter2.GMWMetaData)((GenerateMethodWriter2.GMWMetaData)((GenerateMethodWriter2.GMWMetaData)gmw.metaData()).packageName(fullClassName.substring(0, fullClassName.lastIndexOf(46)))).baseClassName(fullClassName.substring(1 + fullClassName.lastIndexOf(46)))).interfaces(this.interfaces)).genericEvent(this.genericEvent).metaData(this.metaData).useMethodIds(true).useUpdateInterceptor(this.updateInterceptor != null);
        gmw.maxCode(0);
        return gmw.acquireClass(this.classLoader);
    }

    private Object newInstance(Class<?> aClass) {
        try {
            if (this.outSupplier == null) {
                throw new NullPointerException("marshallableOut(out) has not been set.");
            }
            if (this.outSupplier.get().recordHistory()) {
                this.handlerSupplier.recordHistory(true);
            }
            return aClass.getDeclaredConstructors()[0].newInstance(this.outSupplier, this.closeable, this.updateInterceptor);
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public MethodWriterBuilder<T> genericEvent(String genericEvent) {
        this.handlerSupplier.genericEvent(genericEvent);
        this.genericEvent = genericEvent;
        return this;
    }

    public MethodWriterBuilder<T> marshallableOut(@NotNull MarshallableOut out) {
        this.outSupplier = () -> out;
        return this;
    }

    public MethodWriterBuilder<T> marshallableOutSupplier(@NotNull Supplier<MarshallableOut> out) {
        this.outSupplier = out;
        return this;
    }

    public MethodWriterBuilder<T> metaData(boolean metaData) {
        this.metaData = metaData;
        return this;
    }

    public Class<?> proxyClass() {
        return this.proxyClass;
    }

    public MethodWriterBuilder<T> proxyClass(Class<?> proxyClass) {
        if (proxyClass.isInterface()) {
            throw new IllegalArgumentException("expecting a class rather than an interface, proxyClass=" + proxyClass);
        }
        this.proxyClass = proxyClass;
        return this;
    }

    @NotNull
    private String toFirstCapCase(@NotNull String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1).toLowerCase();
    }

    static final class CallSupplierInvocationHandler
    implements InvocationHandler {
        private final UpdateInterceptor updateInterceptor;
        private final MethodWriterInvocationHandlerSupplier handlerSupplier;

        CallSupplierInvocationHandler(@NotNull VanillaMethodWriterBuilder builder) {
            this.updateInterceptor = builder.updateInterceptor;
            this.handlerSupplier = builder.handlerSupplier;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object args0 = args == null ? null : args[args.length - 1];
            return this.updateInterceptor == null || this.updateInterceptor.update(method.getName(), args0) ? this.handlerSupplier.get().invoke(proxy, method, args) : proxy;
        }
    }
}

