/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodWriterInvocationHandler;
import net.openhft.chronicle.core.io.Closeable;

public class MethodWriterInvocationHandlerSupplier
implements Supplier<MethodWriterInvocationHandler> {
    private final Supplier<MethodWriterInvocationHandler> supplier;
    private boolean recordHistory;
    private Closeable closeable;
    private boolean disableThreadSafe;
    private String genericEvent;
    private boolean useMethodIds = true;
    private final ThreadLocal<MethodWriterInvocationHandler> handlerTL = ThreadLocal.withInitial(this::newHandler);
    private MethodWriterInvocationHandler handler;

    public MethodWriterInvocationHandlerSupplier(Supplier<MethodWriterInvocationHandler> supplier) {
        this.supplier = supplier;
    }

    public void recordHistory(boolean recordHistory) {
        this.recordHistory = recordHistory;
    }

    public void onClose(Closeable closeable) {
        this.closeable = closeable;
    }

    public void disableThreadSafe(boolean disableThreadSafe) {
        this.disableThreadSafe = disableThreadSafe;
    }

    public void genericEvent(String genericEvent) {
        this.genericEvent = genericEvent;
    }

    public void useMethodIds(boolean useMethodIds) {
        this.useMethodIds = useMethodIds;
    }

    private MethodWriterInvocationHandler newHandler() {
        MethodWriterInvocationHandler h = this.supplier.get();
        h.genericEvent(this.genericEvent);
        h.onClose(this.closeable);
        h.recordHistory(this.recordHistory);
        h.useMethodIds(this.useMethodIds);
        return h;
    }

    @Override
    public MethodWriterInvocationHandler get() {
        if (this.disableThreadSafe) {
            if (this.handler == null) {
                this.handler = this.newHandler();
            }
            return this.handler;
        }
        return this.handlerTL.get();
    }
}

