/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal.fieldinfo;

import java.lang.reflect.Field;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.internal.fieldinfo.UnsafeFieldInfo;
import org.jetbrains.annotations.NotNull;

public final class IntFieldInfo
extends UnsafeFieldInfo {
    public IntFieldInfo(String name, Class<?> type, BracketType bracketType, @NotNull Field field) {
        super(name, type, bracketType, field);
    }

    @Override
    public int getInt(Object object) {
        try {
            return UnsafeMemory.unsafeGetInt((Object)object, (long)this.getOffset());
        }
        catch (NoSuchFieldException e) {
            Jvm.debug().on(IntFieldInfo.class, (Throwable)e);
            return Integer.MIN_VALUE;
        }
    }

    @Override
    public void set(Object object, int value) throws IllegalArgumentException {
        try {
            UnsafeMemory.unsafePutInt((Object)object, (long)this.getOffset(), (int)value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean isEqual(Object a, Object b) {
        return this.getInt(a) == this.getInt(b);
    }

    @Override
    public void copy(Object source, Object destination) {
        this.set(destination, this.getInt(source));
    }
}

