/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.affinity.AffinitySupport;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptComparator;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.VanillaDataCache;
import net.openhft.chronicle.VanillaDateCache;
import net.openhft.chronicle.VanillaIndexCache;
import net.openhft.chronicle.tools.CheckedExcerpt;
import net.openhft.lang.Jvm;
import net.openhft.lang.Maths;
import net.openhft.lang.io.IOTools;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.JDKZObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.constraints.NotNull;

public class VanillaChronicle
implements Chronicle {
    public static final long MIN_CYCLE_LENGTH = TimeUnit.HOURS.toMillis(1L);
    public static final int THREAD_ID_BITS = Integer.getInteger("os.max.pid.bits", Jvm.PID_BITS);
    public static final long THREAD_ID_MASK = -1L >>> -THREAD_ID_BITS;
    public static final int INDEX_DATA_OFFSET_BITS = 64 - THREAD_ID_BITS;
    public static final long INDEX_DATA_OFFSET_MASK = -1L >>> -INDEX_DATA_OFFSET_BITS;
    private final String name;
    private final ThreadLocal<WeakReference<ObjectSerializer>> marshallersCache;
    private final ThreadLocal<WeakReference<VanillaTailer>> tailerCache;
    private final ThreadLocal<WeakReference<VanillaAppender>> appenderCache;
    private final VanillaIndexCache indexCache;
    private final VanillaDataCache dataCache;
    private final VanillaDateCache dateCache;
    private final int indexBlockSizeBits;
    private final int indexBlockSizeMask;
    private final int indexBlockLongsBits;
    private final int indexBlockLongsMask;
    private final int dataBlockSizeBits;
    private final int dataBlockSizeMask;
    private final int entriesForCycleBits;
    private final long entriesForCycleMask;
    private final AtomicLong lastWrittenIndex = new AtomicLong(-1L);
    private volatile boolean closed = false;
    @NotNull
    final ChronicleQueueBuilder.VanillaChronicleQueueBuilder builder;

    VanillaChronicle(ChronicleQueueBuilder.VanillaChronicleQueueBuilder builder) {
        this.builder = builder.clone();
        this.marshallersCache = new ThreadLocal();
        this.tailerCache = new ThreadLocal();
        this.appenderCache = new ThreadLocal();
        this.name = builder.path().getName();
        this.dateCache = new VanillaDateCache(builder.cycleFormat(), builder.cycleLength());
        this.indexBlockSizeBits = Maths.intLog2((long)builder.indexBlockSize());
        this.indexBlockSizeMask = -1 >>> -this.indexBlockSizeBits;
        this.indexBlockLongsBits = this.indexBlockSizeBits - 3;
        this.indexBlockLongsMask = this.indexBlockSizeMask >>> 3;
        this.indexCache = new VanillaIndexCache(this.builder, this.dateCache, this.indexBlockSizeBits);
        this.dataBlockSizeBits = Maths.intLog2((long)builder.dataBlockSize());
        this.dataBlockSizeMask = -1 >>> -this.dataBlockSizeBits;
        this.dataCache = new VanillaDataCache(this.builder, this.dateCache, this.dataBlockSizeBits);
        this.entriesForCycleBits = Maths.intLog2((long)this.builder.entriesPerCycle());
        this.entriesForCycleMask = -1L >>> -this.entriesForCycleBits;
    }

    void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException(this.builder.path() + " is closed");
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    public int getEntriesForCycleBits() {
        return this.entriesForCycleBits;
    }

    ObjectSerializer acquireSerializer() {
        WeakReference<ObjectSerializer> serializerRef = this.marshallersCache.get();
        ObjectSerializer serializer = null;
        if (serializerRef != null) {
            serializer = (ObjectSerializer)serializerRef.get();
        }
        if (serializer == null) {
            serializer = BytesMarshallableSerializer.create((BytesMarshallerFactory)new VanillaBytesMarshallerFactory(), (ObjectSerializer)((ObjectSerializer)(this.builder.useCompressedObjectSerializer() ? JDKZObjectSerializer.INSTANCE : JDKObjectSerializer.INSTANCE)));
            this.marshallersCache.set(new WeakReference<ObjectSerializer>(serializer));
        }
        return serializer;
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        WeakReference<VanillaTailer> ref = this.tailerCache.get();
        VanillaTailer tailer = null;
        if (ref != null && (tailer = (VanillaTailer)ref.get()) != null && tailer.unmapped()) {
            tailer = null;
        }
        if (tailer == null) {
            tailer = this.createTailer0();
            this.tailerCache.set(new WeakReference<VanillaTailer>(tailer));
        }
        return tailer;
    }

    private VanillaTailer createTailer0() {
        return new VanillaTailerImpl();
    }

    @Override
    @NotNull
    public VanillaAppender createAppender() throws IOException {
        WeakReference<VanillaAppender> ref = this.appenderCache.get();
        VanillaAppender appender = null;
        if (ref != null && (appender = (VanillaAppender)ref.get()) != null && appender.unmapped()) {
            appender = null;
        }
        if (appender == null) {
            appender = this.createAppender0();
            this.appenderCache.set(new WeakReference<VanillaAppender>(appender));
        }
        return appender;
    }

    private VanillaAppender createAppender0() {
        VanillaAppenderImpl appender = new VanillaAppenderImpl();
        return !this.builder.useCheckedExcerpt() ? appender : new VanillaCheckedAppender(appender);
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() throws IOException {
        Excerpt excerpt = this.builder.useCheckedExcerpt() ? new VanillaExcerpt() : new VanillaCheckedExcerpt(new VanillaExcerpt());
        return excerpt;
    }

    @Override
    public long lastWrittenIndex() {
        return this.lastWrittenIndex.get();
    }

    @Override
    public long lastIndex() {
        int cycle = (int)this.indexCache.lastCycle();
        int lastIndexCount = this.indexCache.lastIndexFile(cycle, -1);
        if (lastIndexCount >= 0) {
            try {
                VanillaMappedBytes buffer = this.indexCache.indexFor(cycle, lastIndexCount, false);
                long indices = VanillaIndexCache.countIndices(buffer);
                buffer.release();
                long indexEntryNumber = indices > 0L ? indices - 1L : 0L;
                return ((long)cycle << this.entriesForCycleBits) + ((long)lastIndexCount << this.indexBlockLongsBits) + indexEntryNumber;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return -1L;
    }

    @Override
    public long size() {
        return this.lastWrittenIndex.get() + 1L;
    }

    @Override
    public void close() {
        this.closed = true;
        this.indexCache.close();
        this.dataCache.close();
    }

    @Override
    public void clear() {
        this.indexCache.close();
        this.dataCache.close();
        IOTools.deleteDir((String)this.builder.path().getAbsolutePath());
    }

    public void checkCounts(int min, int max) {
        this.indexCache.checkCounts(min, max);
        this.dataCache.checkCounts(min, max);
    }

    private final class VanillaCheckedAppender
    extends CheckedExcerpt
    implements VanillaAppender {
        public VanillaCheckedAppender(VanillaAppender common) {
            super(common);
        }

        @Override
        public boolean unmapped() {
            return ((VanillaExcerptCommon)this.wrappedCommon).unmapped();
        }

        @Override
        public void startExcerpt(long capacity, int cycle) {
            ((VanillaAppender)this.wrappedCommon).startExcerpt(capacity, cycle);
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    private final class VanillaCheckedExcerpt
    extends CheckedExcerpt
    implements VanillaExcerptCommon {
        public VanillaCheckedExcerpt(VanillaExcerptCommon common) {
            super(common);
        }

        @Override
        public boolean unmapped() {
            return ((VanillaExcerptCommon)this.wrappedCommon).unmapped();
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    private class VanillaTailerImpl
    extends AbstractVanillaExcerpt
    implements VanillaTailer {
        private VanillaTailerImpl() {
        }

        @Override
        @NotNull
        public ExcerptTailer toStart() {
            super.toStart();
            return this;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            super.toEnd();
            return this;
        }
    }

    private class VanillaAppenderImpl
    extends AbstractVanillaExcerpt
    implements VanillaAppender {
        private int lastCycle;
        private int lastThreadId;
        private int appenderCycle;
        private int appenderThreadId;
        private boolean nextSynchronous;
        private long lastWrittenIndex;
        private long[] positionArr;
        private int dataCount;

        public VanillaAppenderImpl() {
            this.positionArr = new long[]{0L};
            this.lastCycle = Integer.MIN_VALUE;
            this.lastThreadId = Integer.MIN_VALUE;
            this.lastWrittenIndex = -1L;
            this.appenderCycle = -1;
            this.appenderThreadId = -1;
            this.nextSynchronous = VanillaChronicle.this.builder.synchronous();
            this.dataCount = 0;
        }

        @Override
        public void startExcerpt() {
            this.startExcerpt(VanillaChronicle.this.builder.defaultMessageSize(), this.cycle());
        }

        @Override
        public void startExcerpt(long capacity) {
            this.startExcerpt(capacity, this.cycle());
        }

        @Override
        public void startExcerpt(long capacity, int cycle) {
            VanillaChronicle.this.checkNotClosed();
            try {
                this.appenderCycle = cycle;
                this.appenderThreadId = AffinitySupport.getThreadId();
                assert (((long)this.appenderThreadId & THREAD_ID_MASK) == (long)this.appenderThreadId) : "appenderThreadId: " + this.appenderThreadId;
                if (this.appenderCycle != this.lastCycle || this.appenderThreadId != this.lastThreadId) {
                    if (this.dataBytes != null) {
                        this.dataBytes.release();
                        this.dataBytes = null;
                    }
                    if (this.indexBytes != null) {
                        this.indexBytes.release();
                        this.indexBytes = null;
                    }
                    this.lastCycle = this.appenderCycle;
                    this.lastThreadId = this.appenderThreadId;
                }
                if (this.dataBytes == null || this.indexBytes == null) {
                    this.dataCount = VanillaChronicle.this.dataCache.findNextDataCount(this.appenderCycle, this.appenderThreadId);
                    this.dataBytes = VanillaChronicle.this.dataCache.dataFor(this.appenderCycle, this.appenderThreadId, this.dataCount, true);
                }
                if (this.dataBytes.remaining() < capacity + 4L) {
                    this.dataBytes.release();
                    this.dataBytes = null;
                    ++this.dataCount;
                    this.dataBytes = VanillaChronicle.this.dataCache.dataFor(this.appenderCycle, this.appenderThreadId, this.dataCount, true);
                }
                this.startAddr = this.positionAddr = this.dataBytes.positionAddr() + 4L;
                this.limitAddr = this.startAddr + capacity;
                this.nextSynchronous = VanillaChronicle.this.builder.synchronous();
                this.capacityAddr = this.limitAddr;
                this.finished = false;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void addPaddedEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean nextSynchronous() {
            return this.nextSynchronous;
        }

        @Override
        public void nextSynchronous(boolean nextSynchronous) {
            this.nextSynchronous = nextSynchronous;
        }

        @Override
        public void finish() {
            if (this.finished) {
                throw new IllegalStateException("Not started");
            }
            super.finish();
            if (this.dataBytes == null) {
                return;
            }
            int length = ~((int)(this.positionAddr - this.startAddr));
            NativeBytes.UNSAFE.putOrderedInt(null, this.startAddr - 4L, length);
            int offset = (int)(this.startAddr - this.dataBytes.address());
            long dataOffset = this.dataBytes.index() * VanillaChronicle.this.builder.dataBlockSize() + (long)offset;
            long indexValue = ((long)this.appenderThreadId << INDEX_DATA_OFFSET_BITS) + dataOffset;
            try {
                long position = VanillaIndexCache.append(this.indexBytes, indexValue, this.nextSynchronous);
                long lvindex = -1L;
                if (position < 0L) {
                    if (this.indexBytes != null) {
                        this.indexBytes.release();
                        this.indexBytes = null;
                    }
                    this.indexBytes = VanillaChronicle.this.indexCache.append(this.appenderCycle, indexValue, this.nextSynchronous, this.positionArr);
                    lvindex = this.indexFrom(this.appenderCycle, this.indexBytes.index(), this.positionArr[0]);
                } else {
                    lvindex = this.indexFrom(this.appenderCycle, this.indexBytes.index(), position);
                }
                this.setLastWrittenIndex(lvindex);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.setIndex(this.lastWrittenIndex() + 1L);
            this.dataBytes.positionAddr(this.positionAddr);
            this.dataBytes.alignPositionAddr(4);
            if (this.nextSynchronous) {
                this.dataBytes.force();
            }
        }

        private long indexFrom(long cycle, long indexCount, long indexPosition) {
            return (cycle << VanillaChronicle.this.entriesForCycleBits) + (indexCount << VanillaChronicle.this.indexBlockLongsBits) + (indexPosition >> 3);
        }

        @Override
        @NotNull
        public ExcerptAppender toEnd() {
            return this;
        }

        @Override
        public long lastWrittenIndex() {
            return this.lastWrittenIndex;
        }

        protected void setLastWrittenIndex(long lastWrittenIndex) {
            long lwi;
            this.lastWrittenIndex = lastWrittenIndex;
            while ((lwi = VanillaChronicle.this.lastWrittenIndex()) < lastWrittenIndex && !VanillaChronicle.this.lastWrittenIndex.compareAndSet(lwi, lastWrittenIndex)) {
            }
        }
    }

    private class VanillaExcerpt
    extends AbstractVanillaExcerpt
    implements Excerpt {
        private VanillaExcerpt() {
        }

        @Override
        public long findMatch(@NotNull ExcerptComparator comparator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void findRange(@NotNull long[] startEnd, @NotNull ExcerptComparator comparator) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Excerpt toStart() {
            super.toStart();
            return this;
        }

        @Override
        @NotNull
        public Excerpt toEnd() {
            super.toEnd();
            return this;
        }
    }

    private abstract class AbstractVanillaExcerpt
    extends NativeBytes
    implements VanillaExcerptCommon {
        private long index;
        private int lastCycle;
        private int lastIndexCount;
        private int lastThreadId;
        private int lastDataCount;
        protected VanillaMappedBytes indexBytes;
        protected VanillaMappedBytes dataBytes;

        public AbstractVanillaExcerpt() {
            super(VanillaChronicle.this.acquireSerializer(), NO_PAGE, NO_PAGE, null);
            this.index = -1L;
            this.lastCycle = Integer.MIN_VALUE;
            this.lastIndexCount = Integer.MIN_VALUE;
            this.lastThreadId = Integer.MIN_VALUE;
            this.lastDataCount = Integer.MIN_VALUE;
        }

        @Override
        public boolean unmapped() {
            return this.indexBytes == null || this.dataBytes == null || this.indexBytes.unmapped() && this.dataBytes.unmapped();
        }

        @Override
        public boolean wasPadding() {
            return false;
        }

        @Override
        public long index() {
            return this.index;
        }

        protected void setIndex(long index) {
            this.index = index;
        }

        @Override
        public long size() {
            return VanillaChronicle.this.lastWrittenIndex() + 1L;
        }

        @Override
        public Chronicle chronicle() {
            return VanillaChronicle.this;
        }

        public int cycle() {
            return (int)(System.currentTimeMillis() / (long)VanillaChronicle.this.builder.cycleLength());
        }

        public boolean index(long nextIndex) {
            VanillaChronicle.this.checkNotClosed();
            try {
                int len;
                long indexValue;
                int cycle = (int)(nextIndex >>> VanillaChronicle.this.entriesForCycleBits);
                int indexCount = (int)((nextIndex & VanillaChronicle.this.entriesForCycleMask) >>> VanillaChronicle.this.indexBlockLongsBits);
                int indexOffset = (int)(nextIndex & (long)VanillaChronicle.this.indexBlockLongsMask);
                boolean indexFileChange = false;
                try {
                    if (this.lastCycle != cycle || this.lastIndexCount != indexCount || this.indexBytes == null) {
                        if (this.indexBytes != null) {
                            this.indexBytes.release();
                            this.indexBytes = null;
                        }
                        if (this.dataBytes != null) {
                            this.dataBytes.release();
                            this.dataBytes = null;
                        }
                        this.indexBytes = VanillaChronicle.this.indexCache.indexFor(cycle, indexCount, false);
                        indexFileChange = true;
                        assert (this.indexBytes.refCount() > 1);
                        this.lastCycle = cycle;
                        this.lastIndexCount = indexCount;
                    }
                    indexValue = this.indexBytes.readVolatileLong((long)(indexOffset << 3));
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                if (indexValue == 0L) {
                    return false;
                }
                int threadId = (int)(indexValue >>> INDEX_DATA_OFFSET_BITS);
                long dataOffset0 = indexValue & INDEX_DATA_OFFSET_MASK;
                int dataCount = (int)(dataOffset0 >>> VanillaChronicle.this.dataBlockSizeBits);
                int dataOffset = (int)(dataOffset0 & (long)VanillaChronicle.this.dataBlockSizeMask);
                if ((this.lastThreadId != threadId || this.lastDataCount != dataCount || indexFileChange) && this.dataBytes != null) {
                    this.dataBytes.release();
                    this.dataBytes = null;
                }
                if (this.dataBytes == null) {
                    this.dataBytes = VanillaChronicle.this.dataCache.dataFor(cycle, threadId, dataCount, false);
                    this.lastThreadId = threadId;
                    this.lastDataCount = dataCount;
                }
                if ((len = this.dataBytes.readVolatileInt((long)(dataOffset - 4))) == 0) {
                    return false;
                }
                int len2 = ~len;
                if (len2 >>> 30 != 0) {
                    throw new IllegalStateException("Corrupted length " + Integer.toHexString(len));
                }
                this.startAddr = this.positionAddr = this.dataBytes.startAddr() + (long)dataOffset;
                this.capacityAddr = this.limitAddr = this.startAddr + (long)(~len);
                this.index = nextIndex;
                this.finished = false;
                return true;
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }

        public boolean nextIndex() {
            VanillaChronicle.this.checkNotClosed();
            if (this.index < 0L) {
                this.toStart();
                if (this.index < 0L) {
                    return false;
                }
            }
            long nextIndex = this.index + 1L;
            while (true) {
                boolean found;
                if (found = this.index(nextIndex)) {
                    this.index = nextIndex;
                    return true;
                }
                int cycle = (int)(nextIndex / VanillaChronicle.this.builder.entriesPerCycle());
                if (cycle >= this.cycle()) {
                    return false;
                }
                nextIndex = (long)(cycle + 1) * VanillaChronicle.this.builder.entriesPerCycle();
            }
        }

        @NotNull
        public ExcerptCommon toStart() {
            int cycle = (int)VanillaChronicle.this.indexCache.firstCycle();
            if (cycle >= 0) {
                this.index = (long)cycle * VanillaChronicle.this.builder.entriesPerCycle() - 1L;
            }
            return this;
        }

        @NotNull
        protected ExcerptCommon toEnd() {
            long lastIndex = VanillaChronicle.this.lastIndex();
            if (lastIndex < 0L) {
                return this.toStart();
            }
            this.index(lastIndex);
            return this;
        }

        public void close() {
            this.finished = true;
            if (this.indexBytes != null) {
                this.indexBytes.release();
                this.indexBytes = null;
            }
            if (this.dataBytes != null) {
                this.dataBytes.release();
                this.dataBytes = null;
            }
            super.close();
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static interface VanillaTailer
    extends VanillaExcerptCommon,
    ExcerptTailer {
    }

    public static interface VanillaAppender
    extends VanillaExcerptCommon,
    ExcerptAppender {
        public void startExcerpt(long var1, int var3);
    }

    public static interface VanillaExcerptCommon
    extends ExcerptCommon {
        public boolean unmapped();
    }
}

