/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.openhft.chronicle.VanillaDateCache;
import org.jetbrains.annotations.NotNull;

public class VanillaChronicleUtils {
    public static final FileFilter IS_DIR = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static Method GET_ATTRIBUTES;
    private static Object FS;

    public static File mkFiles(File cycleDir, String name, boolean forAppend) throws IOException {
        File file = new File(cycleDir, name);
        if (!forAppend && !VanillaChronicleUtils.exists(file)) {
            return null;
        }
        cycleDir.mkdirs();
        if (!VanillaChronicleUtils.exists(file) && !forAppend) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        return file;
    }

    public static File indexFileFor(int cycle, int indexCount, VanillaDateCache dateCache) {
        return new File(dateCache.valueFor((int)cycle).path, "index-" + indexCount);
    }

    public static File dataFileFor(int cycle, int threadId, int dataCount, VanillaDateCache dateCache) {
        return new File(dateCache.valueFor((int)cycle).path, "data-" + threadId + "-" + dataCount);
    }

    public static List<File> findLeafDirectories(File root) {
        File[] files;
        if (VanillaChronicleUtils.exists(root) && (files = root.listFiles(IS_DIR)) != null && files.length != 0) {
            ArrayList<File> leafs = new ArrayList<File>();
            for (int i = files.length - 1; i >= 0; --i) {
                VanillaChronicleUtils.findLeafDirectories(leafs, files[i]);
            }
            return leafs;
        }
        return Collections.emptyList();
    }

    public static List<File> findLeafDirectories(List<File> leafs, File root) {
        File[] files = root.listFiles(IS_DIR);
        if (files != null && files.length != 0) {
            for (int i = files.length - 1; i >= 0; --i) {
                VanillaChronicleUtils.findLeafDirectories(leafs, files[i]);
            }
        } else {
            leafs.add(root);
        }
        return leafs;
    }

    public static boolean exists(@NotNull File path) {
        try {
            return GET_ATTRIBUTES != null ? (Integer)GET_ATTRIBUTES.invoke(FS, path) > 0 : path.exists();
        }
        catch (Exception e) {
            return path.exists();
        }
    }

    static {
        try {
            Field field = File.class.getDeclaredField("fs");
            field.setAccessible(true);
            FS = field.get(null);
            if (FS != null) {
                try {
                    GET_ATTRIBUTES = FS.getClass().getDeclaredMethod("getBooleanAttributes0", File.class);
                    GET_ATTRIBUTES.setAccessible(true);
                }
                catch (Exception ex) {
                    GET_ATTRIBUTES = null;
                }
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

