/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.openhft.lang.Maths;

class VanillaDateCache {
    private static final int SIZE = 32;
    private final SimpleDateFormat format;
    private final DateValue[] values;
    private final int cycleLength;
    private final File rootPath;

    public VanillaDateCache(String rootPath, String formatStr, int cycleLength, TimeZone timeZone) {
        this(new File(rootPath), formatStr, cycleLength, timeZone);
    }

    public VanillaDateCache(File rootPath, String formatStr, int cycleLength, TimeZone timeZone) {
        this.rootPath = rootPath;
        this.cycleLength = cycleLength;
        this.values = new DateValue[32];
        this.format = new SimpleDateFormat(formatStr);
        this.format.setTimeZone(timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateValue valueFor(int cycle) {
        long millis = (long)cycle * (long)this.cycleLength;
        int hash = (int)Maths.hash((long)millis) & 0x1F;
        DateValue dv = this.values[hash];
        if (dv == null || dv.millis != millis) {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                String text = this.format.format(new Date(millis));
                this.values[hash] = new DateValue(millis, text, new File(this.rootPath, text));
                return this.values[hash];
            }
        }
        return dv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long parseCount(String name) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.format;
        synchronized (simpleDateFormat) {
            return this.format.parse(name).getTime() / (long)this.cycleLength;
        }
    }

    static class DateValue {
        final long millis;
        final String text;
        final File path;

        DateValue(long millis, String text, File path) {
            this.millis = millis;
            this.text = text;
            this.path = path;
        }
    }
}

