/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.IOException;
import java.net.NetworkInterface;
import java.nio.channels.SocketChannel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.tcp.SourceTcp;

public final class SourceTcpInitiator
extends SourceTcp {
    private SocketChannel socketChannel = null;

    public SourceTcpInitiator(ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder) {
        super("source-acceptor", builder, new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    @Override
    protected Runnable createHandler() {
        return new Runnable(){

            @Override
            public void run() {
                while (SourceTcpInitiator.this.running.get()) {
                    SourceTcpInitiator.this.socketChannel = null;
                    while (SourceTcpInitiator.this.running.get() && SourceTcpInitiator.this.socketChannel == null) {
                        try {
                            SourceTcpInitiator.this.socketChannel = SocketChannel.open();
                            SourceTcpInitiator.this.socketChannel.configureBlocking(true);
                            if (SourceTcpInitiator.this.builder.bindAddress() != null) {
                                SourceTcpInitiator.this.socketChannel.bind(SourceTcpInitiator.this.builder.bindAddress());
                            }
                            SourceTcpInitiator.this.socketChannel.connect(SourceTcpInitiator.this.builder.connectAddress());
                            SourceTcpInitiator.this.logger.info("Connected to {} from {}", (Object)SourceTcpInitiator.this.socketChannel.getRemoteAddress(), (Object)SourceTcpInitiator.this.socketChannel.getLocalAddress());
                        }
                        catch (IOException e) {
                            SourceTcpInitiator.this.logger.info("Failed to connect to {}, retrying", (Object)SourceTcpInitiator.this.builder.connectAddress());
                            try {
                                Thread.sleep(SourceTcpInitiator.this.builder.reconnectionIntervalMillis());
                            }
                            catch (InterruptedException e1) {
                                throw new AssertionError((Object)e1);
                            }
                            SourceTcpInitiator.this.socketChannel = null;
                        }
                    }
                    if (SourceTcpInitiator.this.socketChannel == null) continue;
                    SourceTcpInitiator.this.createSessionHandler(SourceTcpInitiator.this.socketChannel).run();
                }
            }
        };
    }

    @Override
    public boolean isLocalhost() {
        if (this.builder.connectAddress().getAddress().isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(this.builder.connectAddress().getAddress()) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

