/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.tools.ChronicleWarmup;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.IByteBufferBytes;
import net.openhft.lang.io.IOTools;
import net.openhft.lang.model.constraints.NotNull;
import org.slf4j.Logger;

public enum ChronicleTools {


    public static void deleteOnExit(String basePath) {
        for (String name : new String[]{basePath + ".data", basePath + ".index"}) {
            File file = new File(name);
            file.delete();
            file.deleteOnExit();
        }
    }

    public static void deleteDirOnExit(String dirPath) {
        DeleteStatic.INSTANCE.add(dirPath);
    }

    public static void logIOException(Logger logger, String message, IOException e) {
        if (e instanceof EOFException) {
            logger.trace(message, (Throwable)e);
        } else {
            logger.warn(message, (Throwable)e);
        }
    }

    public static String asString(ByteBuffer bb) {
        IByteBufferBytes wrap = ByteBufferBytes.wrap((ByteBuffer)bb);
        wrap.position((long)bb.position());
        wrap.limit((long)bb.limit());
        return wrap.toDebugString();
    }

    @NotNull
    public static String asString(@NotNull ExcerptCommon excerpt) {
        return ChronicleTools.asString(excerpt, excerpt.position());
    }

    @NotNull
    private static String asString(@NotNull ExcerptCommon excerpt, long position) {
        return ChronicleTools.asString(excerpt, position, 1024L);
    }

    @NotNull
    private static String asString(@NotNull ExcerptCommon excerpt, long position, long length) {
        long limit = Math.min(position + length, excerpt.capacity());
        StringBuilder sb = new StringBuilder((int)(limit - position));
        for (long i = position; i < limit; ++i) {
            char ch = (char)excerpt.readUnsignedByte(i);
            if (ch < ' ' || ch > '\u007f') {
                ch = '.';
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void warmup() {
        boolean done = ChronicleWarmup.Indexed.DONE;
    }

    public static void checkCount(@NotNull Chronicle chronicle, int min, int max) {
        if (chronicle instanceof VanillaChronicle) {
            ((VanillaChronicle)chronicle).checkCounts(min, max);
        }
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static enum DeleteStatic {
        INSTANCE;

        final Set<String> toDeleteList = new LinkedHashSet<String>();

        private DeleteStatic() {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (String dir : DeleteStatic.this.toDeleteList) {
                        System.out.println("Deleting " + dir.replaceAll("/", "//"));
                        IOTools.deleteDir((String)dir);
                    }
                }
            }));
        }

        synchronized void add(String dirPath) {
            IOTools.deleteDir((String)dirPath);
            this.toDeleteList.add(dirPath);
        }
    }
}

