/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.nio.ByteBuffer;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptComparator;
import net.openhft.chronicle.tcp.ChronicleTcp;
import net.openhft.chronicle.tools.WrappedExcerpt;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.model.constraints.NotNull;

public class WrappedExcerpts {

    public static class ByteBufferBytesExcerptWrapper
    extends WrappedExcerpt {
        private final int defaulCapacity;

        public ByteBufferBytesExcerptWrapper(int defaulCapacity) {
            super(ByteBufferBytesExcerpt.withSize(defaulCapacity));
            this.defaulCapacity = defaulCapacity;
        }

        protected ByteBuffer buffer() {
            return ((ByteBufferBytesExcerpt)this.wrappedExcerpt).buffer();
        }

        protected ByteBufferBytesExcerpt excerpt() {
            return (ByteBufferBytesExcerpt)this.wrappedExcerpt;
        }

        protected void resize(long capacity) {
            if (capacity > Integer.MAX_VALUE) {
                throw new IllegalStateException("Only capacities up to Integer.MAX_VALUE are supported");
            }
            if (capacity > this.excerpt().capacity()) {
                this.setExcerpt(ByteBufferBytesExcerpt.withSize((int)capacity));
            }
            this.excerpt().clear();
            this.excerpt().limit(capacity);
            this.buffer().clear();
            this.buffer().limit((int)capacity);
        }

        protected void cleanup() {
            this.excerpt().clear();
            this.buffer().clear();
        }
    }

    public static class ByteBufferBytesExcerpt
    extends ByteBufferBytes
    implements Excerpt {
        public ByteBufferBytesExcerpt(@NotNull ByteBuffer buffer) {
            super(buffer);
            this.finished = true;
        }

        public static ByteBufferBytesExcerpt withSize(int size) {
            return new ByteBufferBytesExcerpt(ChronicleTcp.createBufferOfSize(size));
        }

        @Override
        public boolean wasPadding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long index() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Chronicle chronicle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long findMatch(@NotNull ExcerptComparator comparator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void findRange(@NotNull long[] startEnd, @NotNull ExcerptComparator comparator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean index(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Excerpt toStart() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Excerpt toEnd() {
            throw new UnsupportedOperationException();
        }
    }
}

