/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.impl.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.collect.impl.*;
import net.openhft.collect.map.hash.HashFloatObjMapFactory;
import net.openhft.function.FloatObjConsumer;
import java.util.function.Predicate;
import net.openhft.collect.map.hash.HashFloatObjMap;

import javax.annotation.Nonnull;
import java.util.*;

import static net.openhft.collect.impl.Containers.sizeAsInt;
import static net.openhft.collect.impl.hash.LHashCapacities.configIsSuitableForMutableLHash;


public abstract class LHashSeparateKVFloatObjMapFactoryGO<V>
        extends LHashSeparateKVFloatObjMapFactorySO<V> {

    LHashSeparateKVFloatObjMapFactoryGO(HashConfig hashConf, int defaultExpectedSize
            ) {
        super(hashConf, defaultExpectedSize);
    }

    

    abstract HashFloatObjMapFactory<V> thisWith(HashConfig hashConf, int defaultExpectedSize);

    abstract HashFloatObjMapFactory<V> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize);

    abstract HashFloatObjMapFactory<V> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize);

    @Override
    public final HashFloatObjMapFactory<V> withHashConfig(@Nonnull HashConfig hashConf) {
        if (configIsSuitableForMutableLHash(hashConf))
            return lHashLikeThisWith(hashConf, getDefaultExpectedSize()
            );
        return qHashLikeThisWith(hashConf, getDefaultExpectedSize()
            );
    }

    @Override
    public final HashFloatObjMapFactory<V> withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == getDefaultExpectedSize())
            return this;
        return thisWith(getHashConfig(), defaultExpectedSize
                );
    }


    @Override
    public String toString() {
        return "HashFloatObjMapFactory[" + commonString() + keySpecialString() +
                ",valueEquivalence=" + getValueEquivalence() +
                
        "]";
    }

    @Override
    public int hashCode() {
        int hashCode = keySpecialHashCode(commonHashCode());
        hashCode = hashCode * 31 + NullableObjects.hashCode(getValueEquivalence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj instanceof HashFloatObjMapFactory) {
            HashFloatObjMapFactory factory = (HashFloatObjMapFactory) obj;
            return commonEquals(factory) && keySpecialEquals(factory) &&
                    NullableObjects.equals(getValueEquivalence(),
                            factory.getValueEquivalence())
;
        } else {
            return false;
        }
    }

    @Override
    public Equivalence<V> getValueEquivalence() {
        return null;
    }

    

    

    

    

    

    

    
    

    
    

    private <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> shrunk(
            UpdatableLHashSeparateKVFloatObjMapGO<V2> map) {
        Predicate<HashContainer> shrinkCondition;
        if ((shrinkCondition = hashConf.getShrinkCondition()) != null) {
            if (shrinkCondition.test(map))
                map.shrink();
        }
        return map;
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap() {
        return newUpdatableMap(getDefaultExpectedSize());
    }
    @Override
    public <V2 extends V> MutableLHashSeparateKVFloatObjMapGO<V2> newMutableMap() {
        return newMutableMap(getDefaultExpectedSize());
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Map<Float, ? extends V2> map) {
        return shrunk(super.newUpdatableMap(map));
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Map<Float, ? extends V2> map1, Map<Float, ? extends V2> map2) {
        long expectedSize = (long) map1.size();
        expectedSize += (long) map2.size();
        return newUpdatableMap(map1, map2, sizeAsInt(expectedSize));
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Map<Float, ? extends V2> map1, Map<Float, ? extends V2> map2,
            Map<Float, ? extends V2> map3) {
        long expectedSize = (long) map1.size();
        expectedSize += (long) map2.size();
        expectedSize += (long) map3.size();
        return newUpdatableMap(map1, map2, map3, sizeAsInt(expectedSize));
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Map<Float, ? extends V2> map1, Map<Float, ? extends V2> map2,
            Map<Float, ? extends V2> map3, Map<Float, ? extends V2> map4) {
        long expectedSize = (long) map1.size();
        expectedSize += (long) map2.size();
        expectedSize += (long) map3.size();
        expectedSize += (long) map4.size();
        return newUpdatableMap(map1, map2, map3, map4, sizeAsInt(expectedSize));
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Map<Float, ? extends V2> map1, Map<Float, ? extends V2> map2,
            Map<Float, ? extends V2> map3, Map<Float, ? extends V2> map4,
            Map<Float, ? extends V2> map5) {
        long expectedSize = (long) map1.size();
        expectedSize += (long) map2.size();
        expectedSize += (long) map3.size();
        expectedSize += (long) map4.size();
        expectedSize += (long) map5.size();
        return newUpdatableMap(map1, map2, map3, map4, map5, sizeAsInt(expectedSize));
    }


    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Map<Float, ? extends V2> map1, Map<Float, ? extends V2> map2,
            int expectedSize) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(expectedSize);
        map.putAll(map1);
        map.putAll(map2);
        return shrunk(map);
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Map<Float, ? extends V2> map1, Map<Float, ? extends V2> map2,
            Map<Float, ? extends V2> map3, int expectedSize) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(expectedSize);
        map.putAll(map1);
        map.putAll(map2);
        map.putAll(map3);
        return shrunk(map);
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Map<Float, ? extends V2> map1, Map<Float, ? extends V2> map2,
            Map<Float, ? extends V2> map3, Map<Float, ? extends V2> map4,
            int expectedSize) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(expectedSize);
        map.putAll(map1);
        map.putAll(map2);
        map.putAll(map3);
        map.putAll(map4);
        return shrunk(map);
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Map<Float, ? extends V2> map1, Map<Float, ? extends V2> map2,
            Map<Float, ? extends V2> map3, Map<Float, ? extends V2> map4,
            Map<Float, ? extends V2> map5, int expectedSize) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(expectedSize);
        map.putAll(map1);
        map.putAll(map2);
        map.putAll(map3);
        map.putAll(map4);
        map.putAll(map5);
        return shrunk(map);
    }


    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier) {
        return newUpdatableMap(entriesSupplier, getDefaultExpectedSize());
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier,
            int expectedSize) {
        final UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(expectedSize);
        entriesSupplier.accept(new FloatObjConsumer<V2>() {
             @Override
             public void accept(float k, V2 v) {
                 map.put(k, v);
             }
         });
        return shrunk(map);
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(float[] keys,
            V2[] values) {
        return newUpdatableMap(keys, values, keys.length);
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(float[] keys,
            V2[] values, int expectedSize) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length)
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        for (int i = 0; i < keys.length; i++) {
            map.put(keys[i], values[i]);
        }
        return shrunk(map);
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Float[] keys, V2[] values) {
        return newUpdatableMap(keys, values, keys.length);
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(
            Float[] keys, V2[] values, int expectedSize) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length)
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        for (int i = 0; i < keys.length; i++) {
            map.put(keys[i], values[i]);
        }
        return shrunk(map);
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(Iterable<Float> keys,
            Iterable<? extends V2> values) {
        int expectedSize = keys instanceof Collection ? ((Collection) keys).size() :
                getDefaultExpectedSize();
        return newUpdatableMap(keys, values, expectedSize);
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMap(Iterable<Float> keys,
            Iterable<? extends V2> values, int expectedSize) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(expectedSize);
        Iterator<Float> keysIt = keys.iterator();
        Iterator<? extends V2> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return shrunk(map);
        } catch (NoSuchElementException e) {
            throw new IllegalArgumentException(
                    "keys and values iterables must have the same size", e);
        }
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMapOf(
            float k1, V2 v1) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMapOf(
            float k1, V2 v1, float k2, V2 v2) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMapOf(
            float k1, V2 v1, float k2, V2 v2,
            float k3, V2 v3) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMapOf(
            float k1, V2 v1, float k2, V2 v2,
            float k3, V2 v3, float k4, V2 v4) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    @Override
    public <V2 extends V> UpdatableLHashSeparateKVFloatObjMapGO<V2> newUpdatableMapOf(
            float k1, V2 v1, float k2, V2 v2,
            float k3, V2 v3, float k4, V2 v4,
            float k5, V2 v5) {
        UpdatableLHashSeparateKVFloatObjMapGO<V2> map = newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    
    


    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, int expectedSize) {
        MutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, expectedSize));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3, int expectedSize) {
        MutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, expectedSize));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, int expectedSize) {
        MutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, expectedSize));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5, int expectedSize) {
        MutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, map5, expectedSize));
        return res;
    }

    
    

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            Map<Float, ? extends V2> map) {
        MutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedMutableMap();
        res.move(newUpdatableMap(map));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2) {
        MutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3) {
        MutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4) {
        MutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5) {
        MutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, map5));
        return res;
    }


    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMap(entriesSupplier));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier,
            int expectedSize) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMap(entriesSupplier, expectedSize));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(float[] keys,
            V2[] values) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(float[] keys,
            V2[] values, int expectedSize) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            Float[] keys, V2[] values) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            Float[] keys, V2[] values, int expectedSize) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Iterable<Float> keys,
            Iterable<? extends V2> values) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMap(Iterable<Float> keys,
            Iterable<? extends V2> values, int expectedSize) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
             float k2, V2 v2) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
             float k2, V2 v2, float k3, V2 v3) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
             float k2, V2 v2, float k3, V2 v3,
             float k4, V2 v4) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
             float k2, V2 v2, float k3, V2 v3,
             float k4, V2 v4, float k5, V2 v5) {
        MutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
    
    


    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, int expectedSize) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, expectedSize));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3, int expectedSize) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, expectedSize));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, int expectedSize) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, expectedSize));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5, int expectedSize) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, map5, expectedSize));
        return res;
    }

    
    

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            Map<Float, ? extends V2> map) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4));
        return res;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, map5));
        return res;
    }


    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMap(entriesSupplier));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier,
            int expectedSize) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMap(entriesSupplier, expectedSize));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(float[] keys,
            V2[] values) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(float[] keys,
            V2[] values, int expectedSize) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            Float[] keys, V2[] values) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            Float[] keys, V2[] values, int expectedSize) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Iterable<Float> keys,
            Iterable<? extends V2> values) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMap(Iterable<Float> keys,
            Iterable<? extends V2> values, int expectedSize) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
             float k2, V2 v2) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
             float k2, V2 v2, float k3, V2 v3) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
             float k2, V2 v2, float k3, V2 v3,
             float k4, V2 v4) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    @Override
    public <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
             float k2, V2 v2, float k3, V2 v3,
             float k4, V2 v4, float k5, V2 v5) {
        ImmutableLHashSeparateKVFloatObjMapGO<V2> map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

