/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalByteDoubleMapOps;
import net.openhft.collect.map.ByteDoubleMap;
import net.openhft.function.ByteDoubleConsumer;
import net.openhft.function.ByteDoublePredicate;

public final class CommonByteDoubleMapOps {
    public static boolean containsAllEntries(final InternalByteDoubleMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ByteDoubleMap) {
            ByteDoubleMap m2 = (ByteDoubleMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalByteDoubleMapOps) {
                return ((InternalByteDoubleMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ByteDoublePredicate(){

                public boolean test(byte a, double b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((byte)((Byte)e.getKey()), (Double)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalByteDoubleMapOps map, Map<? extends Byte, ? extends Double> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteDoubleMap) {
            if (another instanceof InternalByteDoubleMapOps) {
                ((InternalByteDoubleMapOps)another).reversePutAllTo(map);
            } else {
                ((ByteDoubleMap)another).forEach(new ByteDoubleConsumer(){

                    public void accept(byte key, double value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Byte, ? extends Double> e : another.entrySet()) {
                map.justPut((byte)e.getKey(), e.getValue());
            }
        }
    }

    private CommonByteDoubleMapOps() {
    }
}

