/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalByteLongMapOps;
import net.openhft.collect.map.ByteLongMap;
import net.openhft.function.ByteLongConsumer;
import net.openhft.function.ByteLongPredicate;

public final class CommonByteLongMapOps {
    public static boolean containsAllEntries(final InternalByteLongMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ByteLongMap) {
            ByteLongMap m2 = (ByteLongMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalByteLongMapOps) {
                return ((InternalByteLongMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ByteLongPredicate(){

                public boolean test(byte a, long b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Byte)e.getKey(), (Long)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalByteLongMapOps map, Map<? extends Byte, ? extends Long> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteLongMap) {
            if (another instanceof InternalByteLongMapOps) {
                ((InternalByteLongMapOps)another).reversePutAllTo(map);
            } else {
                ((ByteLongMap)another).forEach(new ByteLongConsumer(){

                    public void accept(byte key, long value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Byte, ? extends Long> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonByteLongMapOps() {
    }
}

