/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Collection;
import net.openhft.collect.CharCollection;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalCharCollectionOps;
import net.openhft.collect.set.CharSet;
import net.openhft.function.CharConsumer;
import net.openhft.function.CharPredicate;

public final class CommonCharCollectionOps {
    public static boolean containsAll(final CharCollection collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof CharCollection) {
            CharCollection c2 = (CharCollection)another;
            if (collection instanceof CharSet && c2 instanceof CharSet && collection.size() < another.size()) {
                return false;
            }
            if (c2 instanceof InternalCharCollectionOps) {
                return ((InternalCharCollectionOps)c2).allContainingIn(collection);
            }
            return c2.forEachWhile(new CharPredicate(){

                public boolean test(char value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(((Character)o).charValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(CharCollection collection, Collection<? extends Character> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof CharCollection) {
            if (another instanceof InternalCharCollectionOps) {
                return ((InternalCharCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements CharConsumer {
                boolean collectionChanged = false;
                final /* synthetic */ CharCollection val$collection;

                AddAll(CharCollection charCollection) {
                    this.val$collection = charCollection;
                }

                public void accept(char value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((CharCollection)another).forEach((CharConsumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (Character c : another) {
            collectionChanged |= collection.add(c.charValue());
        }
        return collectionChanged;
    }

    private CommonCharCollectionOps() {
    }
}

