/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalCharFloatMapOps;
import net.openhft.collect.map.CharFloatMap;
import net.openhft.function.CharFloatConsumer;
import net.openhft.function.CharFloatPredicate;

public final class CommonCharFloatMapOps {
    public static boolean containsAllEntries(final InternalCharFloatMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof CharFloatMap) {
            CharFloatMap m2 = (CharFloatMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalCharFloatMapOps) {
                return ((InternalCharFloatMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new CharFloatPredicate(){

                public boolean test(char a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Character)e.getKey()).charValue(), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalCharFloatMapOps map, Map<? extends Character, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof CharFloatMap) {
            if (another instanceof InternalCharFloatMapOps) {
                ((InternalCharFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((CharFloatMap)another).forEach(new CharFloatConsumer(){

                    public void accept(char key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Character, ? extends Float> e : another.entrySet()) {
                map.justPut(e.getKey().charValue(), e.getValue().floatValue());
            }
        }
    }

    private CommonCharFloatMapOps() {
    }
}

