/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalCharShortMapOps;
import net.openhft.collect.map.CharShortMap;
import net.openhft.function.CharShortConsumer;
import net.openhft.function.CharShortPredicate;

public final class CommonCharShortMapOps {
    public static boolean containsAllEntries(final InternalCharShortMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof CharShortMap) {
            CharShortMap m2 = (CharShortMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalCharShortMapOps) {
                return ((InternalCharShortMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new CharShortPredicate(){

                public boolean test(char a, short b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Character)e.getKey()).charValue(), (Short)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalCharShortMapOps map, Map<? extends Character, ? extends Short> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof CharShortMap) {
            if (another instanceof InternalCharShortMapOps) {
                ((InternalCharShortMapOps)another).reversePutAllTo(map);
            } else {
                ((CharShortMap)another).forEach(new CharShortConsumer(){

                    public void accept(char key, short value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Character, ? extends Short> e : another.entrySet()) {
                map.justPut(e.getKey().charValue(), e.getValue());
            }
        }
    }

    private CommonCharShortMapOps() {
    }
}

