/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalDoubleByteMapOps;
import net.openhft.collect.map.DoubleByteMap;
import net.openhft.function.DoubleByteConsumer;
import net.openhft.function.DoubleBytePredicate;

public final class CommonDoubleByteMapOps {
    public static boolean containsAllEntries(final InternalDoubleByteMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof DoubleByteMap) {
            DoubleByteMap m2 = (DoubleByteMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalDoubleByteMapOps) {
                return ((InternalDoubleByteMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new DoubleBytePredicate(){

                public boolean test(double a, byte b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Double)e.getKey(), (byte)((Byte)e.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalDoubleByteMapOps map, Map<? extends Double, ? extends Byte> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof DoubleByteMap) {
            if (another instanceof InternalDoubleByteMapOps) {
                ((InternalDoubleByteMapOps)another).reversePutAllTo(map);
            } else {
                ((DoubleByteMap)another).forEach(new DoubleByteConsumer(){

                    public void accept(double key, byte value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Double, ? extends Byte> e : another.entrySet()) {
                map.justPut(e.getKey(), (byte)e.getValue());
            }
        }
    }

    private CommonDoubleByteMapOps() {
    }
}

