/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Collection;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import net.openhft.collect.DoubleCollection;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalDoubleCollectionOps;
import net.openhft.collect.set.DoubleSet;

public final class CommonDoubleCollectionOps {
    public static boolean containsAll(final DoubleCollection collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof DoubleCollection) {
            DoubleCollection c2 = (DoubleCollection)another;
            if (collection instanceof DoubleSet && c2 instanceof DoubleSet && collection.size() < another.size()) {
                return false;
            }
            if (c2 instanceof InternalDoubleCollectionOps) {
                return ((InternalDoubleCollectionOps)c2).allContainingIn(collection);
            }
            return c2.forEachWhile(new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(((Double)o).doubleValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(DoubleCollection collection, Collection<? extends Double> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof DoubleCollection) {
            if (another instanceof InternalDoubleCollectionOps) {
                return ((InternalDoubleCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements DoubleConsumer {
                boolean collectionChanged = false;
                final /* synthetic */ DoubleCollection val$collection;

                AddAll(DoubleCollection doubleCollection) {
                    this.val$collection = doubleCollection;
                }

                @Override
                public void accept(double value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((DoubleCollection)another).forEach((DoubleConsumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (Double d : another) {
            collectionChanged |= collection.add(d.doubleValue());
        }
        return collectionChanged;
    }

    private CommonDoubleCollectionOps() {
    }
}

