/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalFloatCharMapOps;
import net.openhft.collect.map.FloatCharMap;
import net.openhft.function.FloatCharConsumer;
import net.openhft.function.FloatCharPredicate;

public final class CommonFloatCharMapOps {
    public static boolean containsAllEntries(final InternalFloatCharMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof FloatCharMap) {
            FloatCharMap m2 = (FloatCharMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalFloatCharMapOps) {
                return ((InternalFloatCharMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new FloatCharPredicate(){

                public boolean test(float a, char b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Float)e.getKey()).floatValue(), ((Character)e.getValue()).charValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalFloatCharMapOps map, Map<? extends Float, ? extends Character> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof FloatCharMap) {
            if (another instanceof InternalFloatCharMapOps) {
                ((InternalFloatCharMapOps)another).reversePutAllTo(map);
            } else {
                ((FloatCharMap)another).forEach(new FloatCharConsumer(){

                    public void accept(float key, char value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Float, ? extends Character> e : another.entrySet()) {
                map.justPut(e.getKey().floatValue(), e.getValue().charValue());
            }
        }
    }

    private CommonFloatCharMapOps() {
    }
}

