/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalIntLongMapOps;
import net.openhft.collect.map.IntLongMap;
import net.openhft.function.IntLongConsumer;
import net.openhft.function.IntLongPredicate;

public final class CommonIntLongMapOps {
    public static boolean containsAllEntries(final InternalIntLongMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntLongMap) {
            IntLongMap m2 = (IntLongMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalIntLongMapOps) {
                return ((InternalIntLongMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new IntLongPredicate(){

                public boolean test(int a, long b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Integer)e.getKey(), (Long)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalIntLongMapOps map, Map<? extends Integer, ? extends Long> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntLongMap) {
            if (another instanceof InternalIntLongMapOps) {
                ((InternalIntLongMapOps)another).reversePutAllTo(map);
            } else {
                ((IntLongMap)another).forEach(new IntLongConsumer(){

                    public void accept(int key, long value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Integer, ? extends Long> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonIntLongMapOps() {
    }
}

