/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalIntObjMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.map.IntObjMap;
import net.openhft.function.IntObjConsumer;
import net.openhft.function.IntObjPredicate;

public final class CommonIntObjMapOps {
    public static boolean containsAllEntries(final InternalIntObjMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntObjMap) {
            IntObjMap m2 = (IntObjMap)another;
            if (NullableObjects.equals(m2.valueEquivalence(), map.valueEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalIntObjMapOps) {
                    return ((InternalIntObjMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new IntObjPredicate(){

                public boolean test(int a, Object b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Integer)e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <V> void putAll(final InternalIntObjMapOps<V> map, Map<? extends Integer, ? extends V> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntObjMap) {
            if (another instanceof InternalIntObjMapOps) {
                ((InternalIntObjMapOps)another).reversePutAllTo(map);
            } else {
                ((IntObjMap)another).forEach(new IntObjConsumer<V>(){

                    public void accept(int key, V value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<Integer, V> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonIntObjMapOps() {
    }
}

