/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalIntShortMapOps;
import net.openhft.collect.map.IntShortMap;
import net.openhft.function.IntShortConsumer;
import net.openhft.function.IntShortPredicate;

public final class CommonIntShortMapOps {
    public static boolean containsAllEntries(final InternalIntShortMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntShortMap) {
            IntShortMap m2 = (IntShortMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalIntShortMapOps) {
                return ((InternalIntShortMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new IntShortPredicate(){

                public boolean test(int a, short b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Integer)e.getKey(), (Short)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalIntShortMapOps map, Map<? extends Integer, ? extends Short> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntShortMap) {
            if (another instanceof InternalIntShortMapOps) {
                ((InternalIntShortMapOps)another).reversePutAllTo(map);
            } else {
                ((IntShortMap)another).forEach(new IntShortConsumer(){

                    public void accept(int key, short value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Integer, ? extends Short> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonIntShortMapOps() {
    }
}

