/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalLongObjMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.map.LongObjMap;
import net.openhft.function.LongObjConsumer;
import net.openhft.function.LongObjPredicate;

public final class CommonLongObjMapOps {
    public static boolean containsAllEntries(final InternalLongObjMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof LongObjMap) {
            LongObjMap m2 = (LongObjMap)another;
            if (NullableObjects.equals(m2.valueEquivalence(), map.valueEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalLongObjMapOps) {
                    return ((InternalLongObjMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new LongObjPredicate(){

                public boolean test(long a, Object b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Long)e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <V> void putAll(final InternalLongObjMapOps<V> map, Map<? extends Long, ? extends V> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof LongObjMap) {
            if (another instanceof InternalLongObjMapOps) {
                ((InternalLongObjMapOps)another).reversePutAllTo(map);
            } else {
                ((LongObjMap)another).forEach(new LongObjConsumer<V>(){

                    public void accept(long key, V value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<Long, V> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonLongObjMapOps() {
    }
}

