/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalObjByteMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.map.ObjByteMap;
import net.openhft.function.ObjByteConsumer;
import net.openhft.function.ObjBytePredicate;

public final class CommonObjByteMapOps {
    public static boolean containsAllEntries(final InternalObjByteMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjByteMap) {
            ObjByteMap m2 = (ObjByteMap)another;
            if (NullableObjects.equals(m2.keyEquivalence(), map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjByteMapOps) {
                    return ((InternalObjByteMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjBytePredicate(){

                public boolean test(Object a, byte b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), (Byte)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjByteMapOps<K> map, Map<? extends K, ? extends Byte> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjByteMap) {
            if (another instanceof InternalObjByteMapOps) {
                ((InternalObjByteMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjByteMap)another).forEach(new ObjByteConsumer<K>(){

                    public void accept(K key, byte value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Byte> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonObjByteMapOps() {
    }
}

