/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.set.ObjSet;

public final class CommonObjCollectionOps {
    public static boolean containsAll(final ObjCollection<?> collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof ObjCollection) {
            ObjCollection c2 = (ObjCollection)another;
            if (NullableObjects.equals(collection.equivalence(), c2.equivalence())) {
                if (collection instanceof ObjSet && c2 instanceof ObjSet && collection.size() < another.size()) {
                    return false;
                }
                if (c2 instanceof InternalObjCollectionOps) {
                    return ((InternalObjCollectionOps)c2).allContainingIn(collection);
                }
            }
            return c2.forEachWhile(new Predicate(){

                public boolean test(Object value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean addAll(ObjCollection<E> collection, Collection<? extends E> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjCollection) {
            if (another instanceof InternalObjCollectionOps) {
                return ((InternalObjCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements Consumer<E> {
                boolean collectionChanged = false;
                final /* synthetic */ ObjCollection val$collection;

                AddAll(ObjCollection objCollection) {
                    this.val$collection = objCollection;
                }

                @Override
                public void accept(E value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((ObjCollection)another).forEach((Consumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (E v : another) {
            collectionChanged |= collection.add(v);
        }
        return collectionChanged;
    }

    private CommonObjCollectionOps() {
    }
}

