/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import java.util.function.ObjDoubleConsumer;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalObjDoubleMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.map.ObjDoubleMap;
import net.openhft.function.ObjDoublePredicate;

public final class CommonObjDoubleMapOps {
    public static boolean containsAllEntries(final InternalObjDoubleMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjDoubleMap) {
            ObjDoubleMap m2 = (ObjDoubleMap)another;
            if (NullableObjects.equals(m2.keyEquivalence(), map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjDoubleMapOps) {
                    return ((InternalObjDoubleMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjDoublePredicate(){

                public boolean test(Object a, double b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), (Double)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjDoubleMapOps<K> map, Map<? extends K, ? extends Double> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjDoubleMap) {
            if (another instanceof InternalObjDoubleMapOps) {
                ((InternalObjDoubleMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjDoubleMap)another).forEach(new ObjDoubleConsumer<K>(){

                    @Override
                    public void accept(K key, double value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Double> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonObjDoubleMapOps() {
    }
}

