/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import java.util.function.ObjIntConsumer;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalObjIntMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.map.ObjIntMap;
import net.openhft.function.ObjIntPredicate;

public final class CommonObjIntMapOps {
    public static boolean containsAllEntries(final InternalObjIntMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjIntMap) {
            ObjIntMap m2 = (ObjIntMap)another;
            if (NullableObjects.equals(m2.keyEquivalence(), map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjIntMapOps) {
                    return ((InternalObjIntMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjIntPredicate(){

                public boolean test(Object a, int b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), (Integer)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjIntMapOps<K> map, Map<? extends K, ? extends Integer> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjIntMap) {
            if (another instanceof InternalObjIntMapOps) {
                ((InternalObjIntMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjIntMap)another).forEach(new ObjIntConsumer<K>(){

                    @Override
                    public void accept(K key, int value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Integer> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonObjIntMapOps() {
    }
}

