/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Collection;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalShortCollectionOps;
import net.openhft.collect.set.ShortSet;
import net.openhft.function.ShortConsumer;
import net.openhft.function.ShortPredicate;

public final class CommonShortCollectionOps {
    public static boolean containsAll(final ShortCollection collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof ShortCollection) {
            ShortCollection c2 = (ShortCollection)another;
            if (collection instanceof ShortSet && c2 instanceof ShortSet && collection.size() < another.size()) {
                return false;
            }
            if (c2 instanceof InternalShortCollectionOps) {
                return ((InternalShortCollectionOps)c2).allContainingIn(collection);
            }
            return c2.forEachWhile(new ShortPredicate(){

                public boolean test(short value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(((Short)o).shortValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(ShortCollection collection, Collection<? extends Short> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortCollection) {
            if (another instanceof InternalShortCollectionOps) {
                return ((InternalShortCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements ShortConsumer {
                boolean collectionChanged = false;
                final /* synthetic */ ShortCollection val$collection;

                AddAll(ShortCollection shortCollection) {
                    this.val$collection = shortCollection;
                }

                public void accept(short value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((ShortCollection)another).forEach((ShortConsumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (Short s : another) {
            collectionChanged |= collection.add(s.shortValue());
        }
        return collectionChanged;
    }

    private CommonShortCollectionOps() {
    }
}

