/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalShortFloatMapOps;
import net.openhft.collect.map.ShortFloatMap;
import net.openhft.function.ShortFloatConsumer;
import net.openhft.function.ShortFloatPredicate;

public final class CommonShortFloatMapOps {
    public static boolean containsAllEntries(final InternalShortFloatMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortFloatMap) {
            ShortFloatMap m2 = (ShortFloatMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalShortFloatMapOps) {
                return ((InternalShortFloatMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ShortFloatPredicate(){

                public boolean test(short a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((short)((Short)e.getKey()), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalShortFloatMapOps map, Map<? extends Short, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortFloatMap) {
            if (another instanceof InternalShortFloatMapOps) {
                ((InternalShortFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortFloatMap)another).forEach(new ShortFloatConsumer(){

                    public void accept(short key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Short, ? extends Float> e : another.entrySet()) {
                map.justPut((short)e.getKey(), e.getValue().floatValue());
            }
        }
    }

    private CommonShortFloatMapOps() {
    }
}

