/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalShortIntMapOps;
import net.openhft.collect.map.ShortIntMap;
import net.openhft.function.ShortIntConsumer;
import net.openhft.function.ShortIntPredicate;

public final class CommonShortIntMapOps {
    public static boolean containsAllEntries(final InternalShortIntMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortIntMap) {
            ShortIntMap m2 = (ShortIntMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalShortIntMapOps) {
                return ((InternalShortIntMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ShortIntPredicate(){

                public boolean test(short a, int b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Short)e.getKey(), (Integer)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalShortIntMapOps map, Map<? extends Short, ? extends Integer> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortIntMap) {
            if (another instanceof InternalShortIntMapOps) {
                ((InternalShortIntMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortIntMap)another).forEach(new ShortIntConsumer(){

                    public void accept(short key, int value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Short, ? extends Integer> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonShortIntMapOps() {
    }
}

