/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.math.BigDecimal;
import java.math.MathContext;

public class Scaler {
    static final Scaler BY_0_25 = new Scaler(0.25){

        @Override
        public int scaleUpper(int n) {
            Scaler.check(n);
            return (n >> 2) + 1;
        }

        @Override
        public int scaleLower(int n) {
            Scaler.check(n);
            return n >> 2;
        }

        @Override
        public long scaleUpper(long n) {
            Scaler.check(n);
            return (n >> 2) + 1L;
        }

        @Override
        public long scaleLower(long n) {
            Scaler.check(n);
            return n >> 2;
        }
    };
    static final Scaler BY_3_0_INVERSE = new Scaler(0.3333333333333333){

        @Override
        BigDecimal createBD() {
            return BigDecimal.ONE.divide(BigDecimal.valueOf(3L), MathContext.DECIMAL128);
        }
    };
    static final Scaler BY_0_5 = new Scaler(0.5){

        @Override
        public int scaleUpper(int n) {
            Scaler.check(n);
            return (n >> 1) + 1;
        }

        @Override
        public int scaleLower(int n) {
            Scaler.check(n);
            return n >> 1;
        }

        @Override
        public long scaleUpper(long n) {
            Scaler.check(n);
            return (n >> 1) + 1L;
        }

        @Override
        public long scaleLower(long n) {
            Scaler.check(n);
            return n >> 1;
        }
    };
    static final Scaler BY_1_5_INVERSE = new Scaler(0.6666666666666666){

        @Override
        BigDecimal createBD() {
            return BigDecimal.valueOf(2L).divide(BigDecimal.valueOf(3L), MathContext.DECIMAL128);
        }
    };
    static final Scaler BY_0_75 = new Scaler(0.75){

        @Override
        public int scaleUpper(int n) {
            Scaler.check(n);
            int r = n - (n >> 2);
            return (n & 3) != 0 ? r : r + 1;
        }

        @Override
        public int scaleLower(int n) {
            Scaler.check(n);
            int r = n - (n >> 2);
            return (n & 3) != 0 ? r - 1 : r;
        }

        @Override
        public long scaleUpper(long n) {
            Scaler.check(n);
            long r = n - (n >> 2);
            return (n & 3L) != 0L ? r : r + 1L;
        }

        @Override
        public long scaleLower(long n) {
            Scaler.check(n);
            long r = n - (n >> 2);
            return (n & 3L) != 0L ? r - 1L : r;
        }
    };
    static final Scaler BY_1_0 = new Scaler(1.0){

        @Override
        public int scaleUpper(int n) {
            Scaler.check(n);
            return n < Integer.MAX_VALUE ? n + 1 : Integer.MAX_VALUE;
        }

        @Override
        public int scaleLower(int n) {
            Scaler.check(n);
            return n;
        }

        @Override
        public long scaleUpper(long n) {
            Scaler.check(n);
            return n < Long.MAX_VALUE ? n + 1L : Long.MAX_VALUE;
        }

        @Override
        public long scaleLower(long n) {
            Scaler.check(n);
            return n;
        }
    };
    static final Scaler BY_0_75_INVERSE = new Scaler(1.3333333333333333){

        @Override
        BigDecimal createBD() {
            return BigDecimal.valueOf(4L).divide(BigDecimal.valueOf(3L), MathContext.DECIMAL128);
        }
    };
    static final Scaler BY_1_5 = new Scaler(1.5){

        @Override
        public int scaleUpper(int n) {
            Scaler.check(n);
            return n <= 0x55555554 ? n + (n >> 1) + 1 : Integer.MAX_VALUE;
        }

        @Override
        public int scaleLower(int n) {
            Scaler.check(n);
            return n <= 0x55555554 ? n + (n >> 1) : Integer.MAX_VALUE;
        }

        @Override
        public long scaleUpper(long n) {
            Scaler.check(n);
            return n <= 0x5555555555555554L ? n + (n >> 1) + 1L : Long.MAX_VALUE;
        }

        @Override
        public long scaleLower(long n) {
            Scaler.check(n);
            return n <= 0x5555555555555554L ? n + (n >> 1) : Long.MAX_VALUE;
        }
    };
    static final Scaler BY_2_0 = new Scaler(2.0){

        @Override
        public int scaleUpper(int n) {
            Scaler.check(n);
            return n < 0x40000000 ? (n << 1) + 1 : Integer.MAX_VALUE;
        }

        @Override
        public int scaleLower(int n) {
            Scaler.check(n);
            return n < 0x40000000 ? n << 1 : Integer.MAX_VALUE;
        }

        @Override
        public long scaleUpper(long n) {
            Scaler.check(n);
            return n < 0x4000000000000000L ? (n << 1) + 1L : Long.MAX_VALUE;
        }

        @Override
        public long scaleLower(long n) {
            Scaler.check(n);
            return n < 0x4000000000000000L ? n << 1 : Long.MAX_VALUE;
        }
    };
    static final Scaler BY_3_0 = new Scaler(3.0){

        @Override
        public int scaleUpper(int n) {
            Scaler.check(n);
            return n <= 0x2AAAAAAA ? n + (n << 1) + 1 : Integer.MAX_VALUE;
        }

        @Override
        public int scaleLower(int n) {
            Scaler.check(n);
            return n <= 0x2AAAAAAA ? n + (n << 1) : Integer.MAX_VALUE;
        }

        @Override
        public long scaleUpper(long n) {
            Scaler.check(n);
            return n <= 0x2AAAAAAAAAAAAAAAL ? n + (n << 1) + 1L : Long.MAX_VALUE;
        }

        @Override
        public long scaleLower(long n) {
            Scaler.check(n);
            return n <= 0x2AAAAAAAAAAAAAAAL ? n + (n << 1) : Long.MAX_VALUE;
        }
    };
    static final Scaler BY_4_0 = new Scaler(4.0){

        @Override
        public int scaleUpper(int n) {
            Scaler.check(n);
            return n < 0x20000000 ? (n << 2) + 1 : Integer.MAX_VALUE;
        }

        @Override
        public int scaleLower(int n) {
            Scaler.check(n);
            return n < 0x20000000 ? n << 2 : Integer.MAX_VALUE;
        }

        @Override
        public long scaleUpper(long n) {
            Scaler.check(n);
            return n < 0x2000000000000000L ? (n << 2) + 1L : Long.MAX_VALUE;
        }

        @Override
        public long scaleLower(long n) {
            Scaler.check(n);
            return n < 0x2000000000000000L ? n << 2 : Long.MAX_VALUE;
        }
    };
    private static final BigDecimal LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
    final double scale;
    private BigDecimal scaleAsBD;

    public static Scaler by(double scale) {
        if (Double.isNaN(scale) || scale <= 0.0 || Double.isInfinite(scale)) {
            throw new IllegalArgumentException("Scale should be a finite positive number, " + scale + " is given");
        }
        if (scale == 0.25) {
            return BY_0_25;
        }
        if (scale == 0.3333333333333333) {
            return BY_3_0_INVERSE;
        }
        if (scale == 0.5) {
            return BY_0_5;
        }
        if (scale == 0.6666666666666666) {
            return BY_1_5_INVERSE;
        }
        if (scale == 0.75) {
            return BY_0_75;
        }
        if (scale == 1.0) {
            return BY_1_0;
        }
        if (scale == 1.3333333333333333) {
            return BY_0_75_INVERSE;
        }
        if (scale == 1.5) {
            return BY_1_5;
        }
        if (scale == 2.0) {
            return BY_2_0;
        }
        if (scale == 3.0) {
            return BY_3_0;
        }
        if (scale == 4.0) {
            return BY_4_0;
        }
        return new Scaler(scale);
    }

    private static void check(int n) {
        assert (n >= 0) : "n should be non-negative, otherwise result is undefined";
    }

    private static void check(long n) {
        assert (n >= 0L) : "n should be non-negative, otherwise result is undefined";
    }

    private Scaler(double scale) {
        this.scale = scale;
    }

    private BigDecimal scaleAsBD() {
        return this.scaleAsBD != null ? this.scaleAsBD : (this.scaleAsBD = this.createBD());
    }

    BigDecimal createBD() {
        return BigDecimal.valueOf(this.scale);
    }

    public int scaleUpper(int n) {
        Scaler.check(n);
        int lower = (int)((double)n * this.scale);
        return lower < Integer.MAX_VALUE ? lower + 1 : Integer.MAX_VALUE;
    }

    public int scaleLower(int n) {
        Scaler.check(n);
        return (int)((double)n * this.scale);
    }

    public long scaleUpper(long n) {
        Scaler.check(n);
        if (n < Integer.MAX_VALUE && this.scale < 1.0) {
            return this.scaleUpper((int)n);
        }
        BigDecimal lower = BigDecimal.valueOf(n).multiply(this.scaleAsBD());
        return lower.compareTo(LONG_MAX_VALUE) < 0 ? lower.longValue() + 1L : Long.MAX_VALUE;
    }

    public long scaleLower(long n) {
        Scaler.check(n);
        if (n < Integer.MAX_VALUE && this.scale < 1.0) {
            return this.scaleLower((int)n);
        }
        BigDecimal lower = BigDecimal.valueOf(n).multiply(this.scaleAsBD());
        return lower.compareTo(LONG_MAX_VALUE) < 0 ? lower.longValue() : Long.MAX_VALUE;
    }
}

