/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.CharCollection;
import net.openhft.collect.CharCursor;
import net.openhft.collect.CharIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractCharValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonCharCharMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalCharCharMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.ImmutableLHashParallelKVCharCharMapSO;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.ParallelKVCharCharLHash;
import net.openhft.collect.map.CharCharCursor;
import net.openhft.collect.set.CharSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.CharBinaryOperator;
import net.openhft.function.CharCharConsumer;
import net.openhft.function.CharCharPredicate;
import net.openhft.function.CharCharToCharFunction;
import net.openhft.function.CharConsumer;
import net.openhft.function.CharPredicate;
import net.openhft.function.CharUnaryOperator;

public class ImmutableLHashParallelKVCharCharMapGO
extends ImmutableLHashParallelKVCharCharMapSO {
    final void copy(ParallelKVCharCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVCharCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    @Override
    public boolean containsEntry(char key, char value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return Character.valueOf((char)(entry >>> 16));
            } while (cur != free);
            return null;
        }
        return null;
    }

    public char get(char key) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    @Override
    public Character getOrDefault(Object key, Character defaultValue) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return Character.valueOf((char)(entry >>> 16));
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public char getOrDefault(char key, char defaultValue) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Character, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(Character.valueOf(key), Character.valueOf((char)(entry >>> 16)));
        }
    }

    public void forEach(CharCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(key, (char)(entry >>> 16));
        }
    }

    public boolean forEachWhile(CharCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || predicate.test(key, (char)(entry >>> 16))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public CharCharCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharCharMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalCharCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || m.containsEntry(key, (char)(entry >>> 16))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalCharCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            m.justPut(key, (char)(entry >>> 16));
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Character, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            hashCode += key ^ (char)(entry >>> 16);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((char)(entry >>> 16));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Character put(Character key, Character value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char put(char key, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character putIfAbsent(Character key, Character value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char putIfAbsent(char key, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(char key, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character compute(Character key, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char compute(char key, CharCharToCharFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character computeIfAbsent(Character key, Function<? super Character, ? extends Character> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char computeIfAbsent(char key, CharUnaryOperator mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character computeIfPresent(Character key, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char computeIfPresent(char key, CharCharToCharFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character merge(Character key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char merge(char key, char value, CharBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char addValue(char key, char value) {
        throw new UnsupportedOperationException();
    }

    public char addValue(char key, char addition, char defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Character, ? extends Character> m) {
        CommonCharCharMapOps.putAll(this, m);
    }

    @Override
    public Character replace(Character key, Character value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char replace(char key, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Character key, Character oldValue, Character newValue) {
        return this.replace(key.charValue(), oldValue.charValue(), newValue.charValue());
    }

    @Override
    public boolean replace(char key, char oldValue, char newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Character, ? super Character, ? extends Character> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(CharCharToCharFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(char key) {
        throw new UnsupportedOperationException();
    }

    public char remove(char key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), ((Character)value).charValue());
    }

    public boolean remove(char key, char value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(CharCharPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements CharCharCursor {
        final int[] tab;
        final char free;
        int index;
        char curKey;
        char curValue;

        NoRemovedMapCursor() {
            char free;
            this.tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue);
        }

        public void forEachForward(CharCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key, (char)(entry >>> 16));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (char)(entry >>> 16);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final int[] tab;
        final char free;
        int index;
        char curKey;
        char curValue;

        NoRemovedValueCursor() {
            char free;
            this.tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue);
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (char)(entry >>> 16);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final int[] tab;
        final char free;
        int nextIndex;
        char next;

        NoRemovedValueIterator() {
            this.tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            char free = this.free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((char)entry == free) continue;
                this.next = (char)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] tab = this.tab;
                char free = this.free;
                char prev = this.next;
                while (--nextI >= 0) {
                    int entry = tab[nextI];
                    if ((char)entry == free) continue;
                    this.next = (char)(entry >>> 16);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Character>> {
        final int[] tab;
        final char free;
        int index;
        char curKey;
        char curValue;

        NoRemovedEntryCursor() {
            char free;
            this.tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, (char)(entry >>> 16)));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Character> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (char)(entry >>> 16);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Character>> {
        final int[] tab;
        final char free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            char free = this.free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = new ImmutableEntry(key, (char)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, (char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] tab = this.tab;
                char free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    int entry = tab[nextI];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, (char)(entry >>> 16));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVCharCharMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVCharCharMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashParallelKVCharCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return ImmutableLHashParallelKVCharCharMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || predicate.test((char)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || c.contains((char)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= c.add((char)(entry >>> 16));
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= s.removeChar((char)(entry >>> 16));
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public CharCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = Character.valueOf((char)(entry >>> 16));
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = Character.valueOf((char)(entry >>> 16));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = (char)(entry >>> 16);
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = (char)(entry >>> 16);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                sb.append(' ').append((char)(entry >>> 16)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return ImmutableLHashParallelKVCharCharMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVCharCharMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(CharPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends CharCharEntry {
        private char key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends CharCharEntry {
        private final char key;
        private final char value;

        ImmutableEntry(char key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    abstract class CharCharEntry
    extends AbstractEntry<Character, Character> {
        CharCharEntry() {
        }

        abstract char key();

        @Override
        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract char value();

        @Override
        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Character>>
    implements HashObjSet<Map.Entry<Character, Character>>,
    InternalObjCollectionOps<Map.Entry<Character, Character>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Character, Character>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashParallelKVCharCharMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVCharCharMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashParallelKVCharCharMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashParallelKVCharCharMapGO.this.containsEntry(((Character)e.getKey()).charValue(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, (char)(entry >>> 16));
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, (char)(entry >>> 16));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, (char)(entry >>> 16)));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || predicate.test(new ImmutableEntry(key, (char)(entry >>> 16)))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Character, Character>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Character>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (char)(entry >>> 16)));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, (char)(entry >>> 16)));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashParallelKVCharCharMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((char)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVCharCharMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                char value = ((Character)e.getValue()).charValue();
                return ImmutableLHashParallelKVCharCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Character>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVCharCharMapGO.this.clear();
        }
    }
}

