/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.IntCollection;
import net.openhft.collect.IntCursor;
import net.openhft.collect.IntIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractIntValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonCharIntMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalCharIntMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashSeparateKVCharIntMapSO;
import net.openhft.collect.impl.hash.SeparateKVCharIntLHash;
import net.openhft.collect.map.CharIntCursor;
import net.openhft.collect.set.IntSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.CharIntConsumer;
import net.openhft.function.CharIntPredicate;
import net.openhft.function.CharIntToIntFunction;
import net.openhft.function.CharToIntFunction;

public class ImmutableLHashSeparateKVCharIntMapGO
extends ImmutableLHashSeparateKVCharIntMapSO {
    @Override
    final void copy(SeparateKVCharIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(char key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public int get(char key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Integer getOrDefault(Object key, Integer defaultValue) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public int getOrDefault(char key, int defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Character, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(Character.valueOf(key), (Integer)vals[i]);
        }
    }

    public void forEach(CharIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(CharIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public CharIntCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharIntMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalCharIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalCharIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Character, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Integer put(Character key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int put(char key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer putIfAbsent(Character key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putIfAbsent(char key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(char key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer compute(Character key, BiFunction<? super Character, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int compute(char key, CharIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer computeIfAbsent(Character key, Function<? super Character, ? extends Integer> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfAbsent(char key, CharToIntFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer computeIfPresent(Character key, BiFunction<? super Character, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfPresent(char key, CharIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer merge(Character key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int merge(char key, int value, IntBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int addValue(char key, int value) {
        throw new UnsupportedOperationException();
    }

    public int addValue(char key, int addition, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Character, ? extends Integer> m) {
        CommonCharIntMapOps.putAll(this, m);
    }

    @Override
    public Integer replace(Character key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int replace(char key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Character key, Integer oldValue, Integer newValue) {
        return this.replace(key.charValue(), (int)oldValue, (int)newValue);
    }

    @Override
    public boolean replace(char key, int oldValue, int newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Character, ? super Integer, ? extends Integer> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(CharIntToIntFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(char key) {
        throw new UnsupportedOperationException();
    }

    public int remove(char key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), (Integer)value);
    }

    public boolean remove(char key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(CharIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements CharIntCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        int index;
        char curKey;
        int curValue;

        NoRemovedMapCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue);
        }

        public void forEachForward(CharIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        int index;
        char curKey;
        int curValue;

        NoRemovedValueCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue);
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final char[] keys;
        final int[] vals;
        final char free;
        int nextIndex;
        int next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            char free = this.free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] keys = this.keys;
                char free = this.free;
                int prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Integer>> {
        final char[] keys;
        final int[] vals;
        final char free;
        int index;
        char curKey;
        int curValue;

        NoRemovedEntryCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Integer> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Integer>> {
        final char[] keys;
        final int[] vals;
        final char free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            char free = this.free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] keys = this.keys;
                char free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    char key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVCharIntMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVCharIntMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVCharIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return ImmutableLHashSeparateKVCharIntMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeInt(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public IntCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return ImmutableLHashSeparateKVCharIntMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVCharIntMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends CharIntEntry {
        private char key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends CharIntEntry {
        private final char key;
        private final int value;

        ImmutableEntry(char key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class CharIntEntry
    extends AbstractEntry<Character, Integer> {
        CharIntEntry() {
        }

        abstract char key();

        @Override
        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract int value();

        @Override
        public final Integer getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Integer>>
    implements HashObjSet<Map.Entry<Character, Integer>>,
    InternalObjCollectionOps<Map.Entry<Character, Integer>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Character, Integer>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVCharIntMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVCharIntMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVCharIntMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVCharIntMapGO.this.containsEntry(((Character)e.getKey()).charValue(), (Integer)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || predicate.test(new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Character, Integer>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Integer>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashSeparateKVCharIntMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashSeparateKVCharIntMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVCharIntMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                int value = (Integer)e.getValue();
                return ImmutableLHashSeparateKVCharIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVCharIntMapGO.this.clear();
        }
    }
}

