/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.DoubleCollection;
import net.openhft.collect.DoubleCursor;
import net.openhft.collect.DoubleIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractDoubleValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonIntDoubleMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalDoubleCollectionOps;
import net.openhft.collect.impl.InternalIntDoubleMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashSeparateKVIntDoubleMapSO;
import net.openhft.collect.impl.hash.SeparateKVIntDoubleLHash;
import net.openhft.collect.map.IntDoubleCursor;
import net.openhft.collect.set.DoubleSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.IntDoubleConsumer;
import net.openhft.function.IntDoublePredicate;
import net.openhft.function.IntDoubleToDoubleFunction;

public class ImmutableLHashSeparateKVIntDoubleMapGO
extends ImmutableLHashSeparateKVIntDoubleMapSO {
    @Override
    final void copy(SeparateKVIntDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    @Override
    public boolean containsEntry(int key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Double.doubleToLongBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(int key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return null;
    }

    public double get(int key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public double getOrDefault(int key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept((Integer)key, (Double)Double.longBitsToDouble(vals[i]));
        }
    }

    public void forEach(IntDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept(key, Double.longBitsToDouble(vals[i]));
        }
    }

    public boolean forEachWhile(IntDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public IntDoubleCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntDoubleMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalIntDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalIntDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Integer, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            long val = vals[i];
            hashCode += key ^ (int)(val ^ val >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Double.longBitsToDouble(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Double put(Integer key, Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double put(int key, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double putIfAbsent(Integer key, Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double putIfAbsent(int key, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(int key, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(int key, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double compute(Integer key, BiFunction<? super Integer, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double compute(int key, IntDoubleToDoubleFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double computeIfAbsent(Integer key, Function<? super Integer, ? extends Double> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double computeIfAbsent(int key, IntToDoubleFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double computeIfPresent(Integer key, BiFunction<? super Integer, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double computeIfPresent(int key, IntDoubleToDoubleFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double merge(Integer key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double merge(int key, double value, DoubleBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double addValue(int key, double value) {
        throw new UnsupportedOperationException();
    }

    public double addValue(int key, double addition, double defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Integer, ? extends Double> m) {
        CommonIntDoubleMapOps.putAll(this, m);
    }

    @Override
    public Double replace(Integer key, Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double replace(int key, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Integer key, Double oldValue, Double newValue) {
        return this.replace((int)key, (double)oldValue, (double)newValue);
    }

    @Override
    public boolean replace(int key, double oldValue, double newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Double, ? extends Double> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(IntDoubleToDoubleFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public double remove(int key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, (Double)value);
    }

    public boolean remove(int key, double value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(IntDoublePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements IntDoubleCursor {
        final int[] keys;
        final long[] vals;
        final int free;
        int index;
        int curKey;
        long curValue;

        NoRemovedMapCursor() {
            int free;
            this.keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue);
        }

        public void forEachForward(IntDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            int[] keys = this.keys;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final int[] keys;
        final long[] vals;
        final int free;
        int index;
        int curKey;
        long curValue;

        NoRemovedValueCursor() {
            int free;
            this.keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue);
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] keys = this.keys;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final int[] keys;
        final long[] vals;
        final int free;
        int nextIndex;
        double next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] keys = this.keys;
                int free = this.free;
                double prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = Double.longBitsToDouble(this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Double>> {
        final int[] keys;
        final long[] vals;
        final int free;
        int index;
        int curKey;
        long curValue;

        NoRemovedEntryCursor() {
            int free;
            this.keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Double> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] keys = this.keys;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Double>> {
        final int[] keys;
        final long[] vals;
        final int free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            int free = this.free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] keys = this.keys;
                int free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    int key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(long bits) {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(Double.longBitsToDouble(vals[i]));
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeDouble(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public DoubleCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeDouble(long bits) {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVIntDoubleMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(DoublePredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends IntDoubleEntry {
        private int key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends IntDoubleEntry {
        private final int key;
        private final long value;

        ImmutableEntry(int key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    abstract class IntDoubleEntry
    extends AbstractEntry<Integer, Double> {
        IntDoubleEntry() {
        }

        abstract int key();

        @Override
        public final Integer getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Double>>
    implements HashObjSet<Map.Entry<Integer, Double>>,
    InternalObjCollectionOps<Map.Entry<Integer, Double>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Integer, Double>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVIntDoubleMapGO.this.containsEntry((int)((Integer)e.getKey()), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || predicate.test(new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Integer, Double>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Double>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableLHashSeparateKVIntDoubleMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVIntDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVIntDoubleMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                double value = (Double)e.getValue();
                return ImmutableLHashSeparateKVIntDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Double>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVIntDoubleMapGO.this.clear();
        }
    }
}

