/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.ImmutableLHash;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.ParallelKVIntLHash;

public abstract class ImmutableParallelKVIntLHashSO
extends ImmutableLHash
implements ParallelKVIntLHash,
PrimitiveConstants,
UnsafeConstants {
    int freeValue;
    long[] table;

    void copy(ParallelKVIntLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVIntLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, int freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public int freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public int removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Integer)key);
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix(key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }
}

