/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.ImmutableQHash;
import net.openhft.collect.impl.hash.ParallelKVLongQHash;
import net.openhft.collect.impl.hash.QHash;

public abstract class ImmutableParallelKVLongQHashSO
extends ImmutableQHash
implements ParallelKVLongQHash,
PrimitiveConstants,
UnsafeConstants {
    long freeValue;
    long[] table;

    void copy(ParallelKVLongQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVLongQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, long freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public long freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public long removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Long)key);
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
            long cur = tab[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 4;
            }
        }
        return -1;
    }
}

