/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractObjValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonShortObjMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalShortObjMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableQHashSeparateKVShortObjMapSO;
import net.openhft.collect.impl.hash.SeparateKVShortObjQHash;
import net.openhft.collect.map.ShortObjCursor;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.ShortFunction;
import net.openhft.function.ShortObjConsumer;
import net.openhft.function.ShortObjFunction;
import net.openhft.function.ShortObjPredicate;

public class ImmutableQHashSeparateKVShortObjMapGO<V>
extends ImmutableQHashSeparateKVShortObjMapSO<V> {
    @Override
    final void copy(SeparateKVShortObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Equivalence<V> valueEquivalence() {
        return null;
    }

    @Override
    public boolean containsEntry(short key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.values[index], value);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V get(short key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public V getOrDefault(short key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Short, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public void forEach(ShortObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(ShortObjPredicate<? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ShortObjCursor<V> cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortObjMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalShortObjMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalShortObjMapOps<? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Short, V>> entrySet() {
        return new EntryView();
    }

    @Override
    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            hashCode += key ^ this.nullableValueHashCode(vals[i]);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            Object val = vals[i];
            sb.append(val != this ? val : "(this Map)");
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public V put(Short key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(short key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(Short key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(short key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(short key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V compute(Short key, BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V compute(short key, ShortObjFunction<? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfAbsent(Short key, Function<? super Short, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfAbsent(short key, ShortFunction<? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfPresent(Short key, BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfPresent(short key, ShortObjFunction<? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V merge(Short key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V merge(short key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Short, ? extends V> m) {
        CommonShortObjMapOps.putAll(this, m);
    }

    @Override
    public V replace(Short key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(short key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Short key, V oldValue, V newValue) {
        return this.replace((short)key, oldValue, newValue);
    }

    @Override
    public boolean replace(short key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Short, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ShortObjFunction<? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(short key) {
        throw new UnsupportedOperationException();
    }

    public V remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, value);
    }

    public boolean remove(short key, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortObjPredicate<? super V> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ShortObjCursor<V> {
        final short[] keys;
        final V[] vals;
        final short free;
        int index;
        short curKey;
        V curValue;

        NoRemovedMapCursor() {
            short free;
            this.keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue);
        }

        public void forEachForward(ShortObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        final short[] keys;
        final V[] vals;
        final short free;
        int index;
        short curKey;
        V curValue;

        NoRemovedValueCursor() {
            short free;
            this.keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        final short[] keys;
        final V[] vals;
        final short free;
        int nextIndex;
        V next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            short free = this.free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                short[] keys = this.keys;
                short free = this.free;
                Object prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, V>> {
        final short[] keys;
        final V[] vals;
        final short free;
        int index;
        short curKey;
        V curValue;

        NoRemovedEntryCursor() {
            short free;
            this.keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, V> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, V>> {
        final short[] keys;
        final V[] vals;
        final short free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            short free = this.free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                short key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, V> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                short[] keys = this.keys;
                short free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    short key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return ImmutableQHashSeparateKVShortObjMapGO.this.valueEquivalence();
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVShortObjMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVShortObjMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVShortObjMapGO.this.containsValue(o);
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.remove(vals[i]);
            }
            return changed;
        }

        @Override
        @Nonnull
        public ObjIterator<V> iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object val;
                if (keys[i] == free) continue;
                sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return ImmutableQHashSeparateKVShortObjMapGO.this.removeValue(o);
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVShortObjMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ShortObjEntry {
        private short key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ShortObjEntry {
        private final short key;
        private final V value;

        ImmutableEntry(short key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    abstract class ShortObjEntry
    extends AbstractEntry<Short, V> {
        ShortObjEntry() {
        }

        abstract short key();

        @Override
        public final Short getKey() {
            return this.key();
        }

        abstract V value();

        @Override
        public final V getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                Object v2 = e2.getValue();
                return this.key() == k2 && ImmutableQHashSeparateKVShortObjMapGO.this.nullableValueEquals(this.value(), v2);
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ ImmutableQHashSeparateKVShortObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, V>>
    implements HashObjSet<Map.Entry<Short, V>>,
    InternalObjCollectionOps<Map.Entry<Short, V>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Short, V>> equivalence() {
            return Equivalence.entryEquivalence(null, ImmutableQHashSeparateKVShortObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVShortObjMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVShortObjMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVShortObjMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVShortObjMapGO.this.containsEntry((Short)e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || predicate.test(new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Short, V>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, V>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableQHashSeparateKVShortObjMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableQHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Collection)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVShortObjMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                Object value = e.getValue();
                return ImmutableQHashSeparateKVShortObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, V>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVShortObjMapGO.this.clear();
        }
    }
}

