/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.ImmutableQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVDoubleQHash;

public abstract class ImmutableSeparateKVDoubleQHashSO
extends ImmutableQHash
implements SeparateKVDoubleQHash,
PrimitiveConstants,
UnsafeConstants {
    long[] set;

    void copy(SeparateKVDoubleQHash hash) {
        super.copy(hash);
        this.set = (long[])hash.keys().clone();
    }

    void move(SeparateKVDoubleQHash hash) {
        super.copy(hash);
        this.set = hash.keys();
    }

    public boolean contains(Object key) {
        return this.contains((Double)key);
    }

    public boolean contains(double key) {
        return this.index(Double.doubleToLongBits(key)) >= 0;
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
        long cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFFFFFFFFFEL) {
            return -1;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = keys[bIndex]) == key) {
                return bIndex;
            }
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return -1;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = keys[fIndex]) == key) {
                return fIndex;
            }
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return -1;
            }
            step += 2;
        }
    }
}

