/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.ImmutableLHash;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVLongLHash;

public abstract class ImmutableSeparateKVLongLHashSO
extends ImmutableLHash
implements SeparateKVLongLHash,
PrimitiveConstants,
UnsafeConstants {
    long freeValue;
    long[] set;

    void copy(SeparateKVLongLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (long[])hash.keys().clone();
    }

    void move(SeparateKVLongLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, long freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public long freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public long removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Long)key);
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long free = this.freeValue;
        if (key != free) {
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
            long cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }
}

