/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.CharCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.CharLHashFactory;
import net.openhft.collect.impl.hash.ImmutableLHashCharSet;
import net.openhft.collect.impl.hash.ImmutableLHashCharSetGO;
import net.openhft.collect.impl.hash.MutableLHashCharSet;
import net.openhft.collect.impl.hash.MutableLHashCharSetGO;
import net.openhft.collect.impl.hash.SeparateKVCharLHash;
import net.openhft.collect.impl.hash.UpdatableLHashCharSet;
import net.openhft.collect.impl.hash.UpdatableLHashCharSetGO;
import net.openhft.collect.set.hash.HashCharSetFactory;

public abstract class LHashCharSetFactorySO
extends CharLHashFactory
implements HashCharSetFactory {
    LHashCharSetFactorySO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    MutableLHashCharSetGO uninitializedMutableSet() {
        return new MutableLHashCharSet();
    }

    UpdatableLHashCharSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashCharSet();
    }

    ImmutableLHashCharSetGO uninitializedImmutableSet() {
        return new ImmutableLHashCharSet();
    }

    public MutableLHashCharSetGO newMutableSet(int expectedSize) {
        MutableLHashCharSet set = new MutableLHashCharSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableLHashCharSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashCharSet set = new UpdatableLHashCharSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elements, int expectedSize) {
        if (elements instanceof CharCollection) {
            SeparateKVCharLHash hash;
            if (elements instanceof SeparateKVCharLHash && (hash = (SeparateKVCharLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashCharSet set = new UpdatableLHashCharSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashCharSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashCharSetGO set = this.newUpdatableSet(size);
        for (char e : elements) {
            set.add(e);
        }
        return set;
    }
}

