/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.DoubleConsumer;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.hash.ImmutableLHashDoubleSetGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.LHashDoubleSetFactorySO;
import net.openhft.collect.impl.hash.MutableLHashDoubleSetGO;
import net.openhft.collect.impl.hash.SeparateKVDoubleLHash;
import net.openhft.collect.impl.hash.UpdatableLHashDoubleSetGO;
import net.openhft.collect.set.hash.HashDoubleSet;
import net.openhft.collect.set.hash.HashDoubleSetFactory;
import net.openhft.function.Consumer;
import net.openhft.function.Predicate;

public abstract class LHashDoubleSetFactoryGO
extends LHashDoubleSetFactorySO {
    public LHashDoubleSetFactoryGO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    abstract HashDoubleSetFactory thisWith(HashConfig var1, int var2);

    abstract HashDoubleSetFactory lHashLikeThisWith(HashConfig var1, int var2);

    abstract HashDoubleSetFactory qHashLikeThisWith(HashConfig var1, int var2);

    public final HashDoubleSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
    }

    public final HashDoubleSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize);
    }

    public String toString() {
        return "HashDoubleSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashDoubleSetFactory) {
            HashDoubleSetFactory factory = (HashDoubleSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals(factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableLHashDoubleSetGO shrunk(UpdatableLHashDoubleSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(set)) {
            set.shrink();
        }
        return set;
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    public MutableLHashDoubleSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elements) {
        return this.newUpdatableSet((Iterable)elements, LHashDoubleSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2) {
        long expectedSize = LHashDoubleSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt(expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems2, 0)));
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3) {
        long expectedSize = LHashDoubleSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt(expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems3, 0)));
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4) {
        long expectedSize = LHashDoubleSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt(expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems4, 0)));
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5) {
        long expectedSize = LHashDoubleSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt(expectedSize += (long)LHashDoubleSetFactoryGO.sizeOr(elems5, 0)));
    }

    @Override
    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elements, int expectedSize) {
        return this.shrunk((UpdatableLHashDoubleSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableLHashDoubleSetGO set, Iterable<? extends Double> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Double> iterator = elems.iterator();
            while (iterator.hasNext()) {
                double e = iterator.next();
                set.add(e);
            }
        }
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, int expectedSize) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        LHashDoubleSetFactoryGO.addAll(set, elems1);
        LHashDoubleSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        LHashDoubleSetFactoryGO.addAll(set, elems1);
        LHashDoubleSetFactoryGO.addAll(set, elems2);
        LHashDoubleSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, int expectedSize) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        LHashDoubleSetFactoryGO.addAll(set, elems1);
        LHashDoubleSetFactoryGO.addAll(set, elems2);
        LHashDoubleSetFactoryGO.addAll(set, elems3);
        LHashDoubleSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        LHashDoubleSetFactoryGO.addAll(set, elems1);
        LHashDoubleSetFactoryGO.addAll(set, elems2);
        LHashDoubleSetFactoryGO.addAll(set, elems3);
        LHashDoubleSetFactoryGO.addAll(set, elems4);
        LHashDoubleSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterator<Double> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterator<Double> elements, int expectedSize) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Consumer<DoubleConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Consumer<DoubleConsumer> elementsSupplier, int expectedSize) {
        final UpdatableLHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept((Object)new DoubleConsumer(){

            @Override
            public void accept(double e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(double[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(double[] elements, int expectedSize) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        for (double e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Double[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSet(Double[] elements, int expectedSize) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        Double[] doubleArray = elements;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double e = doubleArray[i];
            set.add(e);
        }
        return this.shrunk(set);
    }

    public UpdatableLHashDoubleSetGO newUpdatableSetOf(double e1) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    public UpdatableLHashDoubleSetGO newUpdatableSetOf(double e1, double e2) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    public UpdatableLHashDoubleSetGO newUpdatableSetOf(double e1, double e2, double e3) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    public UpdatableLHashDoubleSetGO newUpdatableSetOf(double e1, double e2, double e3, double e4) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    public UpdatableLHashDoubleSetGO newUpdatableSetOf(double e1, double e2, double e3, double e4, double e5, double ... restElements) {
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (double e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elements, int expectedSize) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, int expectedSize) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, int expectedSize) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elements) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterator<Double> elements) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    public HashDoubleSet newMutableSet(Iterator<Double> elements, int expectedSize) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    public HashDoubleSet newMutableSet(Consumer<DoubleConsumer> elementsSupplier) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    public HashDoubleSet newMutableSet(Consumer<DoubleConsumer> elementsSupplier, int expectedSize) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    public HashDoubleSet newMutableSet(double[] elements) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashDoubleSet newMutableSet(double[] elements, int expectedSize) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashDoubleSet newMutableSet(Double[] elements) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashDoubleSet newMutableSet(Double[] elements, int expectedSize) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashDoubleSet newMutableSetOf(double e1) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    public HashDoubleSet newMutableSetOf(double e1, double e2) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    public HashDoubleSet newMutableSetOf(double e1, double e2, double e3) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    public HashDoubleSet newMutableSetOf(double e1, double e2, double e3, double e4) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    public HashDoubleSet newMutableSetOf(double e1, double e2, double e3, double e4, double e5, double ... restElements) {
        MutableLHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elements, int expectedSize) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, int expectedSize) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, int expectedSize) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elements) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterator<Double> elements) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    public HashDoubleSet newImmutableSet(Iterator<Double> elements, int expectedSize) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    public HashDoubleSet newImmutableSet(Consumer<DoubleConsumer> elementsSupplier) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    public HashDoubleSet newImmutableSet(Consumer<DoubleConsumer> elementsSupplier, int expectedSize) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleLHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    public HashDoubleSet newImmutableSet(double[] elements) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashDoubleSet newImmutableSet(double[] elements, int expectedSize) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashDoubleSet newImmutableSet(Double[] elements) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashDoubleSet newImmutableSet(Double[] elements, int expectedSize) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashDoubleSet newImmutableSetOf(double e1) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    public HashDoubleSet newImmutableSetOf(double e1, double e2) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    public HashDoubleSet newImmutableSetOf(double e1, double e2, double e3) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    public HashDoubleSet newImmutableSetOf(double e1, double e2, double e3, double e4) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    public HashDoubleSet newImmutableSetOf(double e1, double e2, double e3, double e4, double e5, double ... restElements) {
        ImmutableLHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

