/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashParallelKVDoubleDoubleMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.LHashParallelKVDoubleDoubleMapFactorySO;
import net.openhft.collect.impl.hash.MutableLHashParallelKVDoubleDoubleMapGO;
import net.openhft.collect.impl.hash.ParallelKVDoubleDoubleLHash;
import net.openhft.collect.impl.hash.UpdatableLHashParallelKVDoubleDoubleMapGO;
import net.openhft.collect.map.hash.HashDoubleDoubleMap;
import net.openhft.collect.map.hash.HashDoubleDoubleMapFactory;
import net.openhft.function.Consumer;
import net.openhft.function.DoubleDoubleConsumer;
import net.openhft.function.Predicate;

public abstract class LHashParallelKVDoubleDoubleMapFactoryGO
extends LHashParallelKVDoubleDoubleMapFactorySO {
    LHashParallelKVDoubleDoubleMapFactoryGO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    abstract HashDoubleDoubleMapFactory thisWith(HashConfig var1, int var2);

    abstract HashDoubleDoubleMapFactory lHashLikeThisWith(HashConfig var1, int var2);

    abstract HashDoubleDoubleMapFactory qHashLikeThisWith(HashConfig var1, int var2);

    public final HashDoubleDoubleMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
    }

    public final HashDoubleDoubleMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize);
    }

    public String toString() {
        return "HashDoubleDoubleMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashDoubleDoubleMapFactory) {
            HashDoubleDoubleMapFactory factory = (HashDoubleDoubleMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals(factory) && Double.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public double getDefaultValue() {
        return 0.0;
    }

    private UpdatableLHashParallelKVDoubleDoubleMapGO shrunk(UpdatableLHashParallelKVDoubleDoubleMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableLHashParallelKVDoubleDoubleMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Map<Double, Double> map) {
        return this.shrunk((UpdatableLHashParallelKVDoubleDoubleMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Map<Double, Double> map1, Map<Double, Double> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4, Map<Double, Double> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Map<Double, Double> map1, Map<Double, Double> map2, int expectedSize) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Double>)map1);
        map.putAll((Map<? extends Double, ? extends Double>)map2);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Double>)map1);
        map.putAll((Map<? extends Double, ? extends Double>)map2);
        map.putAll((Map<? extends Double, ? extends Double>)map3);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4, int expectedSize) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Double>)map1);
        map.putAll((Map<? extends Double, ? extends Double>)map2);
        map.putAll((Map<? extends Double, ? extends Double>)map3);
        map.putAll((Map<? extends Double, ? extends Double>)map4);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Double>)map1);
        map.putAll((Map<? extends Double, ? extends Double>)map2);
        map.putAll((Map<? extends Double, ? extends Double>)map3);
        map.putAll((Map<? extends Double, ? extends Double>)map4);
        map.putAll((Map<? extends Double, ? extends Double>)map5);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Consumer<DoubleDoubleConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Consumer<DoubleDoubleConsumer> entriesSupplier, int expectedSize) {
        final UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new DoubleDoubleConsumer(){

            public void accept(double k, double v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(double[] keys, double[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(double[] keys, double[] values, int expectedSize) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Double[] keys, Double[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Double[] keys, Double[] values, int expectedSize) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Iterable<Double> keys, Iterable<Double> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMap(Iterable<Double> keys, Iterable<Double> values, int expectedSize) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Double> keysIt = keys.iterator();
        Iterator<Double> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMapOf(double k1, double v1) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMapOf(double k1, double v1, double k2, double v2) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMapOf(double k1, double v1, double k2, double v2, double k3, double v3) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMapOf(double k1, double v1, double k2, double v2, double k3, double v3, double k4, double v4) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableLHashParallelKVDoubleDoubleMapGO newUpdatableMapOf(double k1, double v1, double k2, double v2, double k3, double v3, double k4, double v4, double k5, double v5) {
        UpdatableLHashParallelKVDoubleDoubleMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1, Map<Double, Double> map2, int expectedSize) {
        MutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize) {
        MutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4, int expectedSize) {
        MutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize) {
        MutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashDoubleDoubleMap newMutableMap(Map<Double, Double> map) {
        MutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1, Map<Double, Double> map2) {
        MutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3) {
        MutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4) {
        MutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4, Map<Double, Double> map5) {
        MutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashDoubleDoubleMap newMutableMap(Consumer<DoubleDoubleConsumer> entriesSupplier) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashDoubleDoubleMap newMutableMap(Consumer<DoubleDoubleConsumer> entriesSupplier, int expectedSize) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashDoubleDoubleMap newMutableMap(double[] keys, double[] values) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleDoubleMap newMutableMap(double[] keys, double[] values, int expectedSize) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleDoubleMap newMutableMap(Double[] keys, Double[] values) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleDoubleMap newMutableMap(Double[] keys, Double[] values, int expectedSize) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleDoubleMap newMutableMap(Iterable<Double> keys, Iterable<Double> values) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashDoubleDoubleMap newMutableMap(Iterable<Double> keys, Iterable<Double> values, int expectedSize) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashDoubleDoubleMap newMutableMapOf(double k1, double v1) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashDoubleDoubleMap newMutableMapOf(double k1, double v1, double k2, double v2) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashDoubleDoubleMap newMutableMapOf(double k1, double v1, double k2, double v2, double k3, double v3) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashDoubleDoubleMap newMutableMapOf(double k1, double v1, double k2, double v2, double k3, double v3, double k4, double v4) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashDoubleDoubleMap newMutableMapOf(double k1, double v1, double k2, double v2, double k3, double v3, double k4, double v4, double k5, double v5) {
        MutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1, Map<Double, Double> map2, int expectedSize) {
        ImmutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize) {
        ImmutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4, int expectedSize) {
        ImmutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize) {
        ImmutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map) {
        ImmutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1, Map<Double, Double> map2) {
        ImmutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3) {
        ImmutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4) {
        ImmutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1, Map<Double, Double> map2, Map<Double, Double> map3, Map<Double, Double> map4, Map<Double, Double> map5) {
        ImmutableLHashParallelKVDoubleDoubleMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashDoubleDoubleMap newImmutableMap(Consumer<DoubleDoubleConsumer> entriesSupplier) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMap(Consumer<DoubleDoubleConsumer> entriesSupplier, int expectedSize) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMap(double[] keys, double[] values) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMap(double[] keys, double[] values, int expectedSize) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMap(Double[] keys, Double[] values) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMap(Double[] keys, Double[] values, int expectedSize) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMap(Iterable<Double> keys, Iterable<Double> values) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMap(Iterable<Double> keys, Iterable<Double> values, int expectedSize) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVDoubleDoubleLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMapOf(double k1, double v1) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMapOf(double k1, double v1, double k2, double v2) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMapOf(double k1, double v1, double k2, double v2, double k3, double v3) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMapOf(double k1, double v1, double k2, double v2, double k3, double v3, double k4, double v4) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashDoubleDoubleMap newImmutableMapOf(double k1, double v1, double k2, double v2, double k3, double v3, double k4, double v4, double k5, double v5) {
        ImmutableLHashParallelKVDoubleDoubleMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

