/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashParallelKVFloatIntMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.LHashParallelKVFloatIntMapFactorySO;
import net.openhft.collect.impl.hash.MutableLHashParallelKVFloatIntMapGO;
import net.openhft.collect.impl.hash.ParallelKVFloatIntLHash;
import net.openhft.collect.impl.hash.UpdatableLHashParallelKVFloatIntMapGO;
import net.openhft.collect.map.hash.HashFloatIntMap;
import net.openhft.collect.map.hash.HashFloatIntMapFactory;
import net.openhft.function.Consumer;
import net.openhft.function.FloatIntConsumer;
import net.openhft.function.Predicate;

public abstract class LHashParallelKVFloatIntMapFactoryGO
extends LHashParallelKVFloatIntMapFactorySO {
    LHashParallelKVFloatIntMapFactoryGO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    abstract HashFloatIntMapFactory thisWith(HashConfig var1, int var2);

    abstract HashFloatIntMapFactory lHashLikeThisWith(HashConfig var1, int var2);

    abstract HashFloatIntMapFactory qHashLikeThisWith(HashConfig var1, int var2);

    public final HashFloatIntMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
    }

    public final HashFloatIntMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize);
    }

    public String toString() {
        return "HashFloatIntMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashFloatIntMapFactory) {
            HashFloatIntMapFactory factory = (HashFloatIntMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals(factory) && Integer.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public int getDefaultValue() {
        return 0;
    }

    private UpdatableLHashParallelKVFloatIntMapGO shrunk(UpdatableLHashParallelKVFloatIntMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableLHashParallelKVFloatIntMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Map<Float, Integer> map) {
        return this.shrunk((UpdatableLHashParallelKVFloatIntMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Map<Float, Integer> map1, Map<Float, Integer> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4, Map<Float, Integer> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, int expectedSize) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Float, ? extends Integer>)map1);
        map.putAll((Map<? extends Float, ? extends Integer>)map2);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Float, ? extends Integer>)map1);
        map.putAll((Map<? extends Float, ? extends Integer>)map2);
        map.putAll((Map<? extends Float, ? extends Integer>)map3);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4, int expectedSize) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Float, ? extends Integer>)map1);
        map.putAll((Map<? extends Float, ? extends Integer>)map2);
        map.putAll((Map<? extends Float, ? extends Integer>)map3);
        map.putAll((Map<? extends Float, ? extends Integer>)map4);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Float, ? extends Integer>)map1);
        map.putAll((Map<? extends Float, ? extends Integer>)map2);
        map.putAll((Map<? extends Float, ? extends Integer>)map3);
        map.putAll((Map<? extends Float, ? extends Integer>)map4);
        map.putAll((Map<? extends Float, ? extends Integer>)map5);
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Consumer<FloatIntConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Consumer<FloatIntConsumer> entriesSupplier, int expectedSize) {
        final UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new FloatIntConsumer(){

            public void accept(float k, int v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(float[] keys, int[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(float[] keys, int[] values, int expectedSize) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Float[] keys, Integer[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Float[] keys, Integer[] values, int expectedSize) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Iterable<Float> keys, Iterable<Integer> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMap(Iterable<Float> keys, Iterable<Integer> values, int expectedSize) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Float> keysIt = keys.iterator();
        Iterator<Integer> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMapOf(float k1, int v1) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMapOf(float k1, int v1, float k2, int v2) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMapOf(float k1, int v1, float k2, int v2, float k3, int v3) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMapOf(float k1, int v1, float k2, int v2, float k3, int v3, float k4, int v4) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableLHashParallelKVFloatIntMapGO newUpdatableMapOf(float k1, int v1, float k2, int v2, float k3, int v3, float k4, int v4, float k5, int v5) {
        UpdatableLHashParallelKVFloatIntMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashFloatIntMap newMutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, int expectedSize) {
        MutableLHashParallelKVFloatIntMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashFloatIntMap newMutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize) {
        MutableLHashParallelKVFloatIntMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashFloatIntMap newMutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4, int expectedSize) {
        MutableLHashParallelKVFloatIntMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashFloatIntMap newMutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize) {
        MutableLHashParallelKVFloatIntMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashFloatIntMap newMutableMap(Map<Float, Integer> map) {
        MutableLHashParallelKVFloatIntMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashFloatIntMap newMutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2) {
        MutableLHashParallelKVFloatIntMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashFloatIntMap newMutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3) {
        MutableLHashParallelKVFloatIntMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashFloatIntMap newMutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4) {
        MutableLHashParallelKVFloatIntMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashFloatIntMap newMutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4, Map<Float, Integer> map5) {
        MutableLHashParallelKVFloatIntMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashFloatIntMap newMutableMap(Consumer<FloatIntConsumer> entriesSupplier) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashFloatIntMap newMutableMap(Consumer<FloatIntConsumer> entriesSupplier, int expectedSize) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashFloatIntMap newMutableMap(float[] keys, int[] values) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashFloatIntMap newMutableMap(float[] keys, int[] values, int expectedSize) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashFloatIntMap newMutableMap(Float[] keys, Integer[] values) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashFloatIntMap newMutableMap(Float[] keys, Integer[] values, int expectedSize) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashFloatIntMap newMutableMap(Iterable<Float> keys, Iterable<Integer> values) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashFloatIntMap newMutableMap(Iterable<Float> keys, Iterable<Integer> values, int expectedSize) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashFloatIntMap newMutableMapOf(float k1, int v1) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashFloatIntMap newMutableMapOf(float k1, int v1, float k2, int v2) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashFloatIntMap newMutableMapOf(float k1, int v1, float k2, int v2, float k3, int v3) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashFloatIntMap newMutableMapOf(float k1, int v1, float k2, int v2, float k3, int v3, float k4, int v4) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashFloatIntMap newMutableMapOf(float k1, int v1, float k2, int v2, float k3, int v3, float k4, int v4, float k5, int v5) {
        MutableLHashParallelKVFloatIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashFloatIntMap newImmutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, int expectedSize) {
        ImmutableLHashParallelKVFloatIntMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashFloatIntMap newImmutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize) {
        ImmutableLHashParallelKVFloatIntMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashFloatIntMap newImmutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4, int expectedSize) {
        ImmutableLHashParallelKVFloatIntMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashFloatIntMap newImmutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize) {
        ImmutableLHashParallelKVFloatIntMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashFloatIntMap newImmutableMap(Map<Float, Integer> map) {
        ImmutableLHashParallelKVFloatIntMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashFloatIntMap newImmutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2) {
        ImmutableLHashParallelKVFloatIntMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashFloatIntMap newImmutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3) {
        ImmutableLHashParallelKVFloatIntMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashFloatIntMap newImmutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4) {
        ImmutableLHashParallelKVFloatIntMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashFloatIntMap newImmutableMap(Map<Float, Integer> map1, Map<Float, Integer> map2, Map<Float, Integer> map3, Map<Float, Integer> map4, Map<Float, Integer> map5) {
        ImmutableLHashParallelKVFloatIntMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashFloatIntMap newImmutableMap(Consumer<FloatIntConsumer> entriesSupplier) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashFloatIntMap newImmutableMap(Consumer<FloatIntConsumer> entriesSupplier, int expectedSize) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashFloatIntMap newImmutableMap(float[] keys, int[] values) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashFloatIntMap newImmutableMap(float[] keys, int[] values, int expectedSize) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashFloatIntMap newImmutableMap(Float[] keys, Integer[] values) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashFloatIntMap newImmutableMap(Float[] keys, Integer[] values, int expectedSize) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashFloatIntMap newImmutableMap(Iterable<Float> keys, Iterable<Integer> values) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashFloatIntMap newImmutableMap(Iterable<Float> keys, Iterable<Integer> values, int expectedSize) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVFloatIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashFloatIntMap newImmutableMapOf(float k1, int v1) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashFloatIntMap newImmutableMapOf(float k1, int v1, float k2, int v2) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashFloatIntMap newImmutableMapOf(float k1, int v1, float k2, int v2, float k3, int v3) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashFloatIntMap newImmutableMapOf(float k1, int v1, float k2, int v2, float k3, int v3, float k4, int v4) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashFloatIntMap newImmutableMapOf(float k1, int v1, float k2, int v2, float k3, int v3, float k4, int v4, float k5, int v5) {
        ImmutableLHashParallelKVFloatIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

