/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.ByteHashFactory;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashSeparateKVByteIntMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.LHashSeparateKVByteIntMapFactorySO;
import net.openhft.collect.impl.hash.MutableLHashSeparateKVByteIntMapGO;
import net.openhft.collect.impl.hash.SeparateKVByteIntLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVByteIntMapGO;
import net.openhft.collect.map.hash.HashByteIntMap;
import net.openhft.collect.map.hash.HashByteIntMapFactory;
import net.openhft.function.ByteIntConsumer;
import net.openhft.function.Consumer;
import net.openhft.function.Predicate;

public abstract class LHashSeparateKVByteIntMapFactoryGO
extends LHashSeparateKVByteIntMapFactorySO {
    LHashSeparateKVByteIntMapFactoryGO(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashByteIntMapFactory thisWith(HashConfig var1, int var2, byte var3, byte var4);

    abstract HashByteIntMapFactory lHashLikeThisWith(HashConfig var1, int var2, byte var3, byte var4);

    abstract HashByteIntMapFactory qHashLikeThisWith(HashConfig var1, int var2, byte var3, byte var4);

    public final HashByteIntMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashByteIntMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    final HashByteIntMapFactory withDomain(byte lower, byte upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public final HashByteIntMapFactory withKeysDomain(byte lower, byte upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public final HashByteIntMapFactory withKeysDomainComplement(byte lower, byte upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain((byte)(upper + 1), (byte)(lower - 1));
    }

    public String toString() {
        return "HashByteIntMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashByteIntMapFactory) {
            HashByteIntMapFactory factory = (HashByteIntMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((ByteHashFactory)factory) && Integer.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public int getDefaultValue() {
        return 0;
    }

    private UpdatableLHashSeparateKVByteIntMapGO shrunk(UpdatableLHashSeparateKVByteIntMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableLHashSeparateKVByteIntMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Map<Byte, Integer> map) {
        return this.shrunk((UpdatableLHashSeparateKVByteIntMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4, Map<Byte, Integer> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, int expectedSize) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Byte, ? extends Integer>)map1);
        map.putAll((Map<? extends Byte, ? extends Integer>)map2);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Byte, ? extends Integer>)map1);
        map.putAll((Map<? extends Byte, ? extends Integer>)map2);
        map.putAll((Map<? extends Byte, ? extends Integer>)map3);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4, int expectedSize) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Byte, ? extends Integer>)map1);
        map.putAll((Map<? extends Byte, ? extends Integer>)map2);
        map.putAll((Map<? extends Byte, ? extends Integer>)map3);
        map.putAll((Map<? extends Byte, ? extends Integer>)map4);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Byte, ? extends Integer>)map1);
        map.putAll((Map<? extends Byte, ? extends Integer>)map2);
        map.putAll((Map<? extends Byte, ? extends Integer>)map3);
        map.putAll((Map<? extends Byte, ? extends Integer>)map4);
        map.putAll((Map<? extends Byte, ? extends Integer>)map5);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Consumer<ByteIntConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Consumer<ByteIntConsumer> entriesSupplier, int expectedSize) {
        final UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new ByteIntConsumer(){

            public void accept(byte k, int v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(byte[] keys, int[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(byte[] keys, int[] values, int expectedSize) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Byte[] keys, Integer[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Byte[] keys, Integer[] values, int expectedSize) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Iterable<Byte> keys, Iterable<Integer> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMap(Iterable<Byte> keys, Iterable<Integer> values, int expectedSize) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Byte> keysIt = keys.iterator();
        Iterator<Integer> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMapOf(byte k1, int v1) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMapOf(byte k1, int v1, byte k2, int v2) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMapOf(byte k1, int v1, byte k2, int v2, byte k3, int v3) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMapOf(byte k1, int v1, byte k2, int v2, byte k3, int v3, byte k4, int v4) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableLHashSeparateKVByteIntMapGO newUpdatableMapOf(byte k1, int v1, byte k2, int v2, byte k3, int v3, byte k4, int v4, byte k5, int v5) {
        UpdatableLHashSeparateKVByteIntMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashByteIntMap newMutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, int expectedSize) {
        MutableLHashSeparateKVByteIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashByteIntMap newMutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize) {
        MutableLHashSeparateKVByteIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashByteIntMap newMutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4, int expectedSize) {
        MutableLHashSeparateKVByteIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashByteIntMap newMutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize) {
        MutableLHashSeparateKVByteIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashByteIntMap newMutableMap(Map<Byte, Integer> map) {
        MutableLHashSeparateKVByteIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashByteIntMap newMutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2) {
        MutableLHashSeparateKVByteIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashByteIntMap newMutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3) {
        MutableLHashSeparateKVByteIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashByteIntMap newMutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4) {
        MutableLHashSeparateKVByteIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashByteIntMap newMutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4, Map<Byte, Integer> map5) {
        MutableLHashSeparateKVByteIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashByteIntMap newMutableMap(Consumer<ByteIntConsumer> entriesSupplier) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVByteIntLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashByteIntMap newMutableMap(Consumer<ByteIntConsumer> entriesSupplier, int expectedSize) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVByteIntLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashByteIntMap newMutableMap(byte[] keys, int[] values) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashByteIntMap newMutableMap(byte[] keys, int[] values, int expectedSize) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashByteIntMap newMutableMap(Byte[] keys, Integer[] values) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashByteIntMap newMutableMap(Byte[] keys, Integer[] values, int expectedSize) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashByteIntMap newMutableMap(Iterable<Byte> keys, Iterable<Integer> values) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVByteIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashByteIntMap newMutableMap(Iterable<Byte> keys, Iterable<Integer> values, int expectedSize) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVByteIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashByteIntMap newMutableMapOf(byte k1, int v1) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashByteIntMap newMutableMapOf(byte k1, int v1, byte k2, int v2) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashByteIntMap newMutableMapOf(byte k1, int v1, byte k2, int v2, byte k3, int v3) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashByteIntMap newMutableMapOf(byte k1, int v1, byte k2, int v2, byte k3, int v3, byte k4, int v4) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashByteIntMap newMutableMapOf(byte k1, int v1, byte k2, int v2, byte k3, int v3, byte k4, int v4, byte k5, int v5) {
        MutableLHashSeparateKVByteIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashByteIntMap newImmutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, int expectedSize) {
        ImmutableLHashSeparateKVByteIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashByteIntMap newImmutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize) {
        ImmutableLHashSeparateKVByteIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashByteIntMap newImmutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4, int expectedSize) {
        ImmutableLHashSeparateKVByteIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashByteIntMap newImmutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize) {
        ImmutableLHashSeparateKVByteIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashByteIntMap newImmutableMap(Map<Byte, Integer> map) {
        ImmutableLHashSeparateKVByteIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashByteIntMap newImmutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2) {
        ImmutableLHashSeparateKVByteIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashByteIntMap newImmutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3) {
        ImmutableLHashSeparateKVByteIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashByteIntMap newImmutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4) {
        ImmutableLHashSeparateKVByteIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashByteIntMap newImmutableMap(Map<Byte, Integer> map1, Map<Byte, Integer> map2, Map<Byte, Integer> map3, Map<Byte, Integer> map4, Map<Byte, Integer> map5) {
        ImmutableLHashSeparateKVByteIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVByteIntLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashByteIntMap newImmutableMap(Consumer<ByteIntConsumer> entriesSupplier) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVByteIntLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashByteIntMap newImmutableMap(Consumer<ByteIntConsumer> entriesSupplier, int expectedSize) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVByteIntLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashByteIntMap newImmutableMap(byte[] keys, int[] values) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashByteIntMap newImmutableMap(byte[] keys, int[] values, int expectedSize) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashByteIntMap newImmutableMap(Byte[] keys, Integer[] values) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashByteIntMap newImmutableMap(Byte[] keys, Integer[] values, int expectedSize) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashByteIntMap newImmutableMap(Iterable<Byte> keys, Iterable<Integer> values) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVByteIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashByteIntMap newImmutableMap(Iterable<Byte> keys, Iterable<Integer> values, int expectedSize) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVByteIntLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashByteIntMap newImmutableMapOf(byte k1, int v1) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashByteIntMap newImmutableMapOf(byte k1, int v1, byte k2, int v2) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashByteIntMap newImmutableMapOf(byte k1, int v1, byte k2, int v2, byte k3, int v3) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashByteIntMap newImmutableMapOf(byte k1, int v1, byte k2, int v2, byte k3, int v3, byte k4, int v4) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashByteIntMap newImmutableMapOf(byte k1, int v1, byte k2, int v2, byte k3, int v3, byte k4, int v4, byte k5, int v5) {
        ImmutableLHashSeparateKVByteIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

