/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.CharHashFactory;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashSeparateKVCharByteMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.LHashSeparateKVCharByteMapFactorySO;
import net.openhft.collect.impl.hash.MutableLHashSeparateKVCharByteMapGO;
import net.openhft.collect.impl.hash.SeparateKVCharByteLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVCharByteMapGO;
import net.openhft.collect.map.hash.HashCharByteMap;
import net.openhft.collect.map.hash.HashCharByteMapFactory;
import net.openhft.function.CharByteConsumer;
import net.openhft.function.Consumer;
import net.openhft.function.Predicate;

public abstract class LHashSeparateKVCharByteMapFactoryGO
extends LHashSeparateKVCharByteMapFactorySO {
    LHashSeparateKVCharByteMapFactoryGO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashCharByteMapFactory thisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharByteMapFactory lHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharByteMapFactory qHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    public final HashCharByteMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashCharByteMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    final HashCharByteMapFactory withDomain(char lower, char upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public final HashCharByteMapFactory withKeysDomain(char lower, char upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public final HashCharByteMapFactory withKeysDomainComplement(char lower, char upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain((char)(upper + '\u0001'), (char)(lower - '\u0001'));
    }

    public String toString() {
        return "HashCharByteMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashCharByteMapFactory) {
            HashCharByteMapFactory factory = (HashCharByteMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((CharHashFactory)factory) && Byte.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public byte getDefaultValue() {
        return 0;
    }

    private UpdatableLHashSeparateKVCharByteMapGO shrunk(UpdatableLHashSeparateKVCharByteMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableLHashSeparateKVCharByteMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Map<Character, Byte> map) {
        return this.shrunk((UpdatableLHashSeparateKVCharByteMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Map<Character, Byte> map1, Map<Character, Byte> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4, Map<Character, Byte> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, int expectedSize) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Byte>)map1);
        map.putAll((Map<? extends Character, ? extends Byte>)map2);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Byte>)map1);
        map.putAll((Map<? extends Character, ? extends Byte>)map2);
        map.putAll((Map<? extends Character, ? extends Byte>)map3);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4, int expectedSize) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Byte>)map1);
        map.putAll((Map<? extends Character, ? extends Byte>)map2);
        map.putAll((Map<? extends Character, ? extends Byte>)map3);
        map.putAll((Map<? extends Character, ? extends Byte>)map4);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Character, ? extends Byte>)map1);
        map.putAll((Map<? extends Character, ? extends Byte>)map2);
        map.putAll((Map<? extends Character, ? extends Byte>)map3);
        map.putAll((Map<? extends Character, ? extends Byte>)map4);
        map.putAll((Map<? extends Character, ? extends Byte>)map5);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Consumer<CharByteConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Consumer<CharByteConsumer> entriesSupplier, int expectedSize) {
        final UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new CharByteConsumer(){

            public void accept(char k, byte v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(char[] keys, byte[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(char[] keys, byte[] values, int expectedSize) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Character[] keys, Byte[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Character[] keys, Byte[] values, int expectedSize) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Iterable<Character> keys, Iterable<Byte> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMap(Iterable<Character> keys, Iterable<Byte> values, int expectedSize) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Character> keysIt = keys.iterator();
        Iterator<Byte> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMapOf(char k1, byte v1) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMapOf(char k1, byte v1, char k2, byte v2) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMapOf(char k1, byte v1, char k2, byte v2, char k3, byte v3) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMapOf(char k1, byte v1, char k2, byte v2, char k3, byte v3, char k4, byte v4) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableLHashSeparateKVCharByteMapGO newUpdatableMapOf(char k1, byte v1, char k2, byte v2, char k3, byte v3, char k4, byte v4, char k5, byte v5) {
        UpdatableLHashSeparateKVCharByteMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashCharByteMap newMutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, int expectedSize) {
        MutableLHashSeparateKVCharByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashCharByteMap newMutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize) {
        MutableLHashSeparateKVCharByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashCharByteMap newMutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4, int expectedSize) {
        MutableLHashSeparateKVCharByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashCharByteMap newMutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize) {
        MutableLHashSeparateKVCharByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashCharByteMap newMutableMap(Map<Character, Byte> map) {
        MutableLHashSeparateKVCharByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashCharByteMap newMutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2) {
        MutableLHashSeparateKVCharByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashCharByteMap newMutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3) {
        MutableLHashSeparateKVCharByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashCharByteMap newMutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4) {
        MutableLHashSeparateKVCharByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashCharByteMap newMutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4, Map<Character, Byte> map5) {
        MutableLHashSeparateKVCharByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashCharByteMap newMutableMap(Consumer<CharByteConsumer> entriesSupplier) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVCharByteLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashCharByteMap newMutableMap(Consumer<CharByteConsumer> entriesSupplier, int expectedSize) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVCharByteLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashCharByteMap newMutableMap(char[] keys, byte[] values) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharByteMap newMutableMap(char[] keys, byte[] values, int expectedSize) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharByteMap newMutableMap(Character[] keys, Byte[] values) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharByteMap newMutableMap(Character[] keys, Byte[] values, int expectedSize) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharByteMap newMutableMap(Iterable<Character> keys, Iterable<Byte> values) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVCharByteLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashCharByteMap newMutableMap(Iterable<Character> keys, Iterable<Byte> values, int expectedSize) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVCharByteLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashCharByteMap newMutableMapOf(char k1, byte v1) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashCharByteMap newMutableMapOf(char k1, byte v1, char k2, byte v2) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashCharByteMap newMutableMapOf(char k1, byte v1, char k2, byte v2, char k3, byte v3) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashCharByteMap newMutableMapOf(char k1, byte v1, char k2, byte v2, char k3, byte v3, char k4, byte v4) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashCharByteMap newMutableMapOf(char k1, byte v1, char k2, byte v2, char k3, byte v3, char k4, byte v4, char k5, byte v5) {
        MutableLHashSeparateKVCharByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashCharByteMap newImmutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, int expectedSize) {
        ImmutableLHashSeparateKVCharByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashCharByteMap newImmutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize) {
        ImmutableLHashSeparateKVCharByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashCharByteMap newImmutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4, int expectedSize) {
        ImmutableLHashSeparateKVCharByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashCharByteMap newImmutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize) {
        ImmutableLHashSeparateKVCharByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashCharByteMap newImmutableMap(Map<Character, Byte> map) {
        ImmutableLHashSeparateKVCharByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashCharByteMap newImmutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2) {
        ImmutableLHashSeparateKVCharByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashCharByteMap newImmutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3) {
        ImmutableLHashSeparateKVCharByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashCharByteMap newImmutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4) {
        ImmutableLHashSeparateKVCharByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashCharByteMap newImmutableMap(Map<Character, Byte> map1, Map<Character, Byte> map2, Map<Character, Byte> map3, Map<Character, Byte> map4, Map<Character, Byte> map5) {
        ImmutableLHashSeparateKVCharByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVCharByteLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashCharByteMap newImmutableMap(Consumer<CharByteConsumer> entriesSupplier) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVCharByteLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashCharByteMap newImmutableMap(Consumer<CharByteConsumer> entriesSupplier, int expectedSize) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVCharByteLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashCharByteMap newImmutableMap(char[] keys, byte[] values) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharByteMap newImmutableMap(char[] keys, byte[] values, int expectedSize) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharByteMap newImmutableMap(Character[] keys, Byte[] values) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashCharByteMap newImmutableMap(Character[] keys, Byte[] values, int expectedSize) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashCharByteMap newImmutableMap(Iterable<Character> keys, Iterable<Byte> values) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVCharByteLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashCharByteMap newImmutableMap(Iterable<Character> keys, Iterable<Byte> values, int expectedSize) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVCharByteLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashCharByteMap newImmutableMapOf(char k1, byte v1) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashCharByteMap newImmutableMapOf(char k1, byte v1, char k2, byte v2) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashCharByteMap newImmutableMapOf(char k1, byte v1, char k2, byte v2, char k3, byte v3) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashCharByteMap newImmutableMapOf(char k1, byte v1, char k2, byte v2, char k3, byte v3, char k4, byte v4) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashCharByteMap newImmutableMapOf(char k1, byte v1, char k2, byte v2, char k3, byte v3, char k4, byte v4, char k5, byte v5) {
        ImmutableLHashSeparateKVCharByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

